/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint;
import software.amazon.awssdk.services.mediapackagev2.model.IngestEndpointListCopier;
import software.amazon.awssdk.services.mediapackagev2.model.InputSwitchConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.InputType;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Response;
import software.amazon.awssdk.services.mediapackagev2.model.OutputHeaderConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelResponse
extends MediaPackageV2Response
implements ToCopyableBuilder<Builder, UpdateChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateChannelResponse.getter(UpdateChannelResponse::arn)).setter(UpdateChannelResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(UpdateChannelResponse.getter(UpdateChannelResponse::channelName)).setter(UpdateChannelResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(UpdateChannelResponse.getter(UpdateChannelResponse::channelGroupName)).setter(UpdateChannelResponse.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(UpdateChannelResponse.getter(UpdateChannelResponse::createdAt)).setter(UpdateChannelResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(UpdateChannelResponse.getter(UpdateChannelResponse::modifiedAt)).setter(UpdateChannelResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateChannelResponse.getter(UpdateChannelResponse::description)).setter(UpdateChannelResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<IngestEndpoint>> INGEST_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IngestEndpoints").getter(UpdateChannelResponse.getter(UpdateChannelResponse::ingestEndpoints)).setter(UpdateChannelResponse.setter(Builder::ingestEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputType").getter(UpdateChannelResponse.getter(UpdateChannelResponse::inputTypeAsString)).setter(UpdateChannelResponse.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(UpdateChannelResponse.getter(UpdateChannelResponse::eTag)).setter(UpdateChannelResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateChannelResponse.getter(UpdateChannelResponse::tags)).setter(UpdateChannelResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<InputSwitchConfiguration> INPUT_SWITCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSwitchConfiguration").getter(UpdateChannelResponse.getter(UpdateChannelResponse::inputSwitchConfiguration)).setter(UpdateChannelResponse.setter(Builder::inputSwitchConfiguration)).constructor(InputSwitchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSwitchConfiguration").build()}).build();
    private static final SdkField<OutputHeaderConfiguration> OUTPUT_HEADER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputHeaderConfiguration").getter(UpdateChannelResponse.getter(UpdateChannelResponse::outputHeaderConfiguration)).setter(UpdateChannelResponse.setter(Builder::outputHeaderConfiguration)).constructor(OutputHeaderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputHeaderConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD, CHANNEL_GROUP_NAME_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DESCRIPTION_FIELD, INGEST_ENDPOINTS_FIELD, INPUT_TYPE_FIELD, E_TAG_FIELD, TAGS_FIELD, INPUT_SWITCH_CONFIGURATION_FIELD, OUTPUT_HEADER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("ChannelName", CHANNEL_NAME_FIELD);
            this.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("ModifiedAt", MODIFIED_AT_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("IngestEndpoints", INGEST_ENDPOINTS_FIELD);
            this.put("InputType", INPUT_TYPE_FIELD);
            this.put("ETag", E_TAG_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("InputSwitchConfiguration", INPUT_SWITCH_CONFIGURATION_FIELD);
            this.put("OutputHeaderConfiguration", OUTPUT_HEADER_CONFIGURATION_FIELD);
        }
    });
    private final String arn;
    private final String channelName;
    private final String channelGroupName;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String description;
    private final List<IngestEndpoint> ingestEndpoints;
    private final String inputType;
    private final String eTag;
    private final Map<String, String> tags;
    private final InputSwitchConfiguration inputSwitchConfiguration;
    private final OutputHeaderConfiguration outputHeaderConfiguration;

    private UpdateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelGroupName = builder.channelGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.description = builder.description;
        this.ingestEndpoints = builder.ingestEndpoints;
        this.inputType = builder.inputType;
        this.eTag = builder.eTag;
        this.tags = builder.tags;
        this.inputSwitchConfiguration = builder.inputSwitchConfiguration;
        this.outputHeaderConfiguration = builder.outputHeaderConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasIngestEndpoints() {
        return this.ingestEndpoints != null && !(this.ingestEndpoints instanceof SdkAutoConstructList);
    }

    public final List<IngestEndpoint> ingestEndpoints() {
        return this.ingestEndpoints;
    }

    public final InputType inputType() {
        return InputType.fromValue(this.inputType);
    }

    public final String inputTypeAsString() {
        return this.inputType;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final InputSwitchConfiguration inputSwitchConfiguration() {
        return this.inputSwitchConfiguration;
    }

    public final OutputHeaderConfiguration outputHeaderConfiguration() {
        return this.outputHeaderConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngestEndpoints() ? this.ingestEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSwitchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputHeaderConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelResponse)) {
            return false;
        }
        UpdateChannelResponse other = (UpdateChannelResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.description(), other.description()) && this.hasIngestEndpoints() == other.hasIngestEndpoints() && Objects.equals(this.ingestEndpoints(), other.ingestEndpoints()) && Objects.equals(this.inputTypeAsString(), other.inputTypeAsString()) && Objects.equals(this.eTag(), other.eTag()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.inputSwitchConfiguration(), other.inputSwitchConfiguration()) && Objects.equals(this.outputHeaderConfiguration(), other.outputHeaderConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelResponse").add("Arn", (Object)this.arn()).add("ChannelName", (Object)this.channelName()).add("ChannelGroupName", (Object)this.channelGroupName()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Description", (Object)this.description()).add("IngestEndpoints", this.hasIngestEndpoints() ? this.ingestEndpoints() : null).add("InputType", (Object)this.inputTypeAsString()).add("ETag", (Object)this.eTag()).add("Tags", this.hasTags() ? this.tags() : null).add("InputSwitchConfiguration", (Object)this.inputSwitchConfiguration()).add("OutputHeaderConfiguration", (Object)this.outputHeaderConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IngestEndpoints": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpoints()));
            }
            case "InputType": {
                return Optional.ofNullable(clazz.cast(this.inputTypeAsString()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "InputSwitchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputSwitchConfiguration()));
            }
            case "OutputHeaderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputHeaderConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelResponse, T> g) {
        return obj -> g.apply((UpdateChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Response.BuilderImpl
    implements Builder {
        private String arn;
        private String channelName;
        private String channelGroupName;
        private Instant createdAt;
        private Instant modifiedAt;
        private String description;
        private List<IngestEndpoint> ingestEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String inputType;
        private String eTag;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private InputSwitchConfiguration inputSwitchConfiguration;
        private OutputHeaderConfiguration outputHeaderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelResponse model) {
            super(model);
            this.arn(model.arn);
            this.channelName(model.channelName);
            this.channelGroupName(model.channelGroupName);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.description(model.description);
            this.ingestEndpoints(model.ingestEndpoints);
            this.inputType(model.inputType);
            this.eTag(model.eTag);
            this.tags(model.tags);
            this.inputSwitchConfiguration(model.inputSwitchConfiguration);
            this.outputHeaderConfiguration(model.outputHeaderConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IngestEndpoint.Builder> getIngestEndpoints() {
            List<IngestEndpoint.Builder> result = IngestEndpointListCopier.copyToBuilder(this.ingestEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestEndpoints(Collection<IngestEndpoint.BuilderImpl> ingestEndpoints) {
            this.ingestEndpoints = IngestEndpointListCopier.copyFromBuilder(ingestEndpoints);
        }

        @Override
        public final Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints) {
            this.ingestEndpoints = IngestEndpointListCopier.copy(ingestEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(IngestEndpoint ... ingestEndpoints) {
            this.ingestEndpoints(Arrays.asList(ingestEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(Consumer<IngestEndpoint.Builder> ... ingestEndpoints) {
            this.ingestEndpoints(Stream.of(ingestEndpoints).map(c -> (IngestEndpoint)((IngestEndpoint.Builder)IngestEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final InputSwitchConfiguration.Builder getInputSwitchConfiguration() {
            return this.inputSwitchConfiguration != null ? this.inputSwitchConfiguration.toBuilder() : null;
        }

        public final void setInputSwitchConfiguration(InputSwitchConfiguration.BuilderImpl inputSwitchConfiguration) {
            this.inputSwitchConfiguration = inputSwitchConfiguration != null ? inputSwitchConfiguration.build() : null;
        }

        @Override
        public final Builder inputSwitchConfiguration(InputSwitchConfiguration inputSwitchConfiguration) {
            this.inputSwitchConfiguration = inputSwitchConfiguration;
            return this;
        }

        public final OutputHeaderConfiguration.Builder getOutputHeaderConfiguration() {
            return this.outputHeaderConfiguration != null ? this.outputHeaderConfiguration.toBuilder() : null;
        }

        public final void setOutputHeaderConfiguration(OutputHeaderConfiguration.BuilderImpl outputHeaderConfiguration) {
            this.outputHeaderConfiguration = outputHeaderConfiguration != null ? outputHeaderConfiguration.build() : null;
        }

        @Override
        public final Builder outputHeaderConfiguration(OutputHeaderConfiguration outputHeaderConfiguration) {
            this.outputHeaderConfiguration = outputHeaderConfiguration;
            return this;
        }

        @Override
        public UpdateChannelResponse build() {
            return new UpdateChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaPackageV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelResponse> {
        public Builder arn(String var1);

        public Builder channelName(String var1);

        public Builder channelGroupName(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder description(String var1);

        public Builder ingestEndpoints(Collection<IngestEndpoint> var1);

        public Builder ingestEndpoints(IngestEndpoint ... var1);

        public Builder ingestEndpoints(Consumer<IngestEndpoint.Builder> ... var1);

        public Builder inputType(String var1);

        public Builder inputType(InputType var1);

        public Builder eTag(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder inputSwitchConfiguration(InputSwitchConfiguration var1);

        default public Builder inputSwitchConfiguration(Consumer<InputSwitchConfiguration.Builder> inputSwitchConfiguration) {
            return this.inputSwitchConfiguration((InputSwitchConfiguration)((InputSwitchConfiguration.Builder)InputSwitchConfiguration.builder().applyMutation(inputSwitchConfiguration)).build());
        }

        public Builder outputHeaderConfiguration(OutputHeaderConfiguration var1);

        default public Builder outputHeaderConfiguration(Consumer<OutputHeaderConfiguration.Builder> outputHeaderConfiguration) {
            return this.outputHeaderConfiguration((OutputHeaderConfiguration)((OutputHeaderConfiguration.Builder)OutputHeaderConfiguration.builder().applyMutation(outputHeaderConfiguration)).build());
        }
    }
}

