/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScteFilter {
    SPLICE_INSERT("SPLICE_INSERT"),
    BREAK("BREAK"),
    PROVIDER_ADVERTISEMENT("PROVIDER_ADVERTISEMENT"),
    DISTRIBUTOR_ADVERTISEMENT("DISTRIBUTOR_ADVERTISEMENT"),
    PROVIDER_PLACEMENT_OPPORTUNITY("PROVIDER_PLACEMENT_OPPORTUNITY"),
    DISTRIBUTOR_PLACEMENT_OPPORTUNITY("DISTRIBUTOR_PLACEMENT_OPPORTUNITY"),
    PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY("PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY"),
    DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY("DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY"),
    PROGRAM("PROGRAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScteFilter> VALUE_MAP;
    private final String value;

    private ScteFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScteFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScteFilter> knownValues() {
        EnumSet<ScteFilter> knownValues = EnumSet.allOf(ScteFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScteFilter.class, ScteFilter::toString);
    }
}

