/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediapackagev2.DefaultMediaPackageV2AsyncClient;
import software.amazon.awssdk.services.mediapackagev2.DefaultMediaPackageV2BaseClientBuilder;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClient;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClientBuilder;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2ServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackagev2.endpoints.MediaPackageV2EndpointProvider;

@SdkInternalApi
final class DefaultMediaPackageV2AsyncClientBuilder
extends DefaultMediaPackageV2BaseClientBuilder<MediaPackageV2AsyncClientBuilder, MediaPackageV2AsyncClient>
implements MediaPackageV2AsyncClientBuilder {
    DefaultMediaPackageV2AsyncClientBuilder() {
    }

    @Override
    public DefaultMediaPackageV2AsyncClientBuilder endpointProvider(MediaPackageV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaPackageV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaPackageV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        MediaPackageV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaPackageV2AsyncClient client = new DefaultMediaPackageV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaPackageV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaPackageV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

