/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOriginEndpointRequest extends MediaPackageV2Request implements
        ToCopyableBuilder<CreateOriginEndpointRequest.Builder, CreateOriginEndpointRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(CreateOriginEndpointRequest::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateOriginEndpointRequest::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(CreateOriginEndpointRequest::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build())
            .build();

    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerType").getter(getter(CreateOriginEndpointRequest::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()).build();

    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.<Segment> builder(MarshallingType.SDK_POJO)
            .memberName("Segment").getter(getter(CreateOriginEndpointRequest::segment)).setter(setter(Builder::segment))
            .constructor(Segment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateOriginEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-client-token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateOriginEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartoverWindowSeconds").getter(getter(CreateOriginEndpointRequest::startoverWindowSeconds))
            .setter(setter(Builder::startoverWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartoverWindowSeconds").build())
            .build();

    private static final SdkField<List<CreateHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField
            .<List<CreateHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(CreateOriginEndpointRequest::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CreateLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField
            .<List<CreateLowLatencyHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("LowLatencyHlsManifests")
            .getter(getter(CreateOriginEndpointRequest::lowLatencyHlsManifests))
            .setter(setter(Builder::lowLatencyHlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateLowLatencyHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateLowLatencyHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateOriginEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, SEGMENT_FIELD, CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, STARTOVER_WINDOW_SECONDS_FIELD, HLS_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD, TAGS_FIELD));

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String containerType;

    private final Segment segment;

    private final String clientToken;

    private final String description;

    private final Integer startoverWindowSeconds;

    private final List<CreateHlsManifestConfiguration> hlsManifests;

    private final List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;

    private final Map<String, String> tags;

    private CreateOriginEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.segment = builder.segment;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and must
     * be unique for your account in the AWS Region and channel. You can't use spaces in the name. You can't change the
     * name after you create the endpoint.
     * </p>
     * 
     * @return The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint,
     *         and must be unique for your account in the AWS Region and channel. You can't use spaces in the name. You
     *         can't change the name after you create the endpoint.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The type of container to attach to this origin endpoint. A container type is a file format that encapsulates one
     * or more media streams, such as audio and video, into a single file. You can't change the container type after you
     * create the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container to attach to this origin endpoint. A container type is a file format that
     *         encapsulates one or more media streams, such as audio and video, into a single file. You can't change the
     *         container type after you create the endpoint.
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * The type of container to attach to this origin endpoint. A container type is a file format that encapsulates one
     * or more media streams, such as audio and video, into a single file. You can't change the container type after you
     * create the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container to attach to this origin endpoint. A container type is a file format that
     *         encapsulates one or more media streams, such as audio and video, into a single file. You can't change the
     *         container type after you create the endpoint.
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * The segment configuration, including the segment name, duration, and other configuration values.
     * </p>
     * 
     * @return The segment configuration, including the segment name, duration, and other configuration values.
     */
    public final Segment segment() {
        return segment;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Enter any descriptive text that helps you to identify the origin endpoint.
     * </p>
     * 
     * @return Enter any descriptive text that helps you to identify the origin endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing.
     * Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is
     * 1,209,600 seconds (14 days).
     * </p>
     * 
     * @return The size of the window (in seconds) to create a window of the live stream that's available for on-demand
     *         viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum
     *         startover window is 1,209,600 seconds (14 days).
     */
    public final Integer startoverWindowSeconds() {
        return startoverWindowSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the HlsManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An HTTP live streaming (HLS) manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHlsManifests} method.
     * </p>
     * 
     * @return An HTTP live streaming (HLS) manifest configuration.
     */
    public final List<CreateHlsManifestConfiguration> hlsManifests() {
        return hlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the LowLatencyHlsManifests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLowLatencyHlsManifests() {
        return lowLatencyHlsManifests != null && !(lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A low-latency HLS manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLowLatencyHlsManifests} method.
     * </p>
     * 
     * @return A low-latency HLS manifest configuration.
     */
    public final List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return lowLatencyHlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A comma-separated list of tag key:value pairs that you define. For example:
     * </p>
     * <p>
     * <code>"Key1": "Value1",</code>
     * </p>
     * <p>
     * <code>"Key2": "Value2"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A comma-separated list of tag key:value pairs that you define. For example:</p>
     *         <p>
     *         <code>"Key1": "Value1",</code>
     *         </p>
     *         <p>
     *         <code>"Key2": "Value2"</code>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOriginEndpointRequest)) {
            return false;
        }
        CreateOriginEndpointRequest other = (CreateOriginEndpointRequest) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(containerTypeAsString(), other.containerTypeAsString())
                && Objects.equals(segment(), other.segment()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description())
                && Objects.equals(startoverWindowSeconds(), other.startoverWindowSeconds())
                && hasHlsManifests() == other.hasHlsManifests() && Objects.equals(hlsManifests(), other.hlsManifests())
                && hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests()
                && Objects.equals(lowLatencyHlsManifests(), other.lowLatencyHlsManifests()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOriginEndpointRequest").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("ContainerType", containerTypeAsString()).add("Segment", segment()).add("ClientToken", clientToken())
                .add("Description", description()).add("StartoverWindowSeconds", startoverWindowSeconds())
                .add("HlsManifests", hasHlsManifests() ? hlsManifests() : null)
                .add("LowLatencyHlsManifests", hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "ContainerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "Segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StartoverWindowSeconds":
            return Optional.ofNullable(clazz.cast(startoverWindowSeconds()));
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "LowLatencyHlsManifests":
            return Optional.ofNullable(clazz.cast(lowLatencyHlsManifests()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOriginEndpointRequest, T> g) {
        return obj -> g.apply((CreateOriginEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOriginEndpointRequest> {
        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and
         * must be unique for your account in the AWS Region and channel. You can't use spaces in the name. You can't
         * change the name after you create the endpoint.
         * </p>
         * 
         * @param originEndpointName
         *        The name that describes the origin endpoint. The name is the primary identifier for the origin
         *        endpoint, and must be unique for your account in the AWS Region and channel. You can't use spaces in
         *        the name. You can't change the name after you create the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The type of container to attach to this origin endpoint. A container type is a file format that encapsulates
         * one or more media streams, such as audio and video, into a single file. You can't change the container type
         * after you create the endpoint.
         * </p>
         * 
         * @param containerType
         *        The type of container to attach to this origin endpoint. A container type is a file format that
         *        encapsulates one or more media streams, such as audio and video, into a single file. You can't change
         *        the container type after you create the endpoint.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * The type of container to attach to this origin endpoint. A container type is a file format that encapsulates
         * one or more media streams, such as audio and video, into a single file. You can't change the container type
         * after you create the endpoint.
         * </p>
         * 
         * @param containerType
         *        The type of container to attach to this origin endpoint. A container type is a file format that
         *        encapsulates one or more media streams, such as audio and video, into a single file. You can't change
         *        the container type after you create the endpoint.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * The segment configuration, including the segment name, duration, and other configuration values.
         * </p>
         * 
         * @param segment
         *        The segment configuration, including the segment name, duration, and other configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(Segment segment);

        /**
         * <p>
         * The segment configuration, including the segment name, duration, and other configuration values.
         * </p>
         * This is a convenience method that creates an instance of the {@link Segment.Builder} avoiding the need to
         * create one manually via {@link Segment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Segment.Builder#build()} is called immediately and its result is
         * passed to {@link #segment(Segment)}.
         * 
         * @param segment
         *        a consumer that will call methods on {@link Segment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segment(Segment)
         */
        default Builder segment(Consumer<Segment.Builder> segment) {
            return segment(Segment.builder().applyMutation(segment).build());
        }

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Enter any descriptive text that helps you to identify the origin endpoint.
         * </p>
         * 
         * @param description
         *        Enter any descriptive text that helps you to identify the origin endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand
         * viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover
         * window is 1,209,600 seconds (14 days).
         * </p>
         * 
         * @param startoverWindowSeconds
         *        The size of the window (in seconds) to create a window of the live stream that's available for
         *        on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The
         *        maximum startover window is 1,209,600 seconds (14 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startoverWindowSeconds(Integer startoverWindowSeconds);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<CreateHlsManifestConfiguration> hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(CreateHlsManifestConfiguration... hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link #hlsManifests(List<CreateHlsManifestConfiguration>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(java.util.Collection<CreateHlsManifestConfiguration>)
         */
        Builder hlsManifests(Consumer<CreateHlsManifestConfiguration.Builder>... hlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(CreateLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lowLatencyHlsManifests(List<CreateLowLatencyHlsManifestConfiguration>)}.
         * 
         * @param lowLatencyHlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowLatencyHlsManifests(java.util.Collection<CreateLowLatencyHlsManifestConfiguration>)
         */
        Builder lowLatencyHlsManifests(Consumer<CreateLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests);

        /**
         * <p>
         * A comma-separated list of tag key:value pairs that you define. For example:
         * </p>
         * <p>
         * <code>"Key1": "Value1",</code>
         * </p>
         * <p>
         * <code>"Key2": "Value2"</code>
         * </p>
         * 
         * @param tags
         *        A comma-separated list of tag key:value pairs that you define. For example:</p>
         *        <p>
         *        <code>"Key1": "Value1",</code>
         *        </p>
         *        <p>
         *        <code>"Key2": "Value2"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageV2Request.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String containerType;

        private Segment segment;

        private String clientToken;

        private String description;

        private Integer startoverWindowSeconds;

        private List<CreateHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOriginEndpointRequest model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            containerType(model.containerType);
            segment(model.segment);
            clientToken(model.clientToken);
            description(model.description);
            startoverWindowSeconds(model.startoverWindowSeconds);
            hlsManifests(model.hlsManifests);
            lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            tags(model.tags);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final Segment.Builder getSegment() {
            return segment != null ? segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStartoverWindowSeconds() {
            return startoverWindowSeconds;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final List<CreateHlsManifestConfiguration.Builder> getHlsManifests() {
            List<CreateHlsManifestConfiguration.Builder> result = CreateHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<CreateHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = CreateHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<CreateHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = CreateHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(CreateHlsManifestConfiguration... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<CreateHlsManifestConfiguration.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> CreateHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CreateLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<CreateLowLatencyHlsManifestConfiguration.Builder> result = CreateLowLatencyHlsManifestsCopier
                    .copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(
                Collection<CreateLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = CreateLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = CreateLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(CreateLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(
                Consumer<CreateLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests)
                    .map(c -> CreateLowLatencyHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOriginEndpointRequest build() {
            return new CreateOriginEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
