/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Create an HTTP live streaming (HLS) manifest configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHlsManifestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateHlsManifestConfiguration.Builder, CreateHlsManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(CreateHlsManifestConfiguration::manifestName))
            .setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()).build();

    private static final SdkField<String> CHILD_MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChildManifestName").getter(getter(CreateHlsManifestConfiguration::childManifestName))
            .setter(setter(Builder::childManifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildManifestName").build()).build();

    private static final SdkField<ScteHls> SCTE_HLS_FIELD = SdkField.<ScteHls> builder(MarshallingType.SDK_POJO)
            .memberName("ScteHls").getter(getter(CreateHlsManifestConfiguration::scteHls)).setter(setter(Builder::scteHls))
            .constructor(ScteHls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteHls").build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(CreateHlsManifestConfiguration::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramDateTimeIntervalSeconds")
            .getter(getter(CreateHlsManifestConfiguration::programDateTimeIntervalSeconds))
            .setter(setter(Builder::programDateTimeIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramDateTimeIntervalSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD,
            CHILD_MANIFEST_NAME_FIELD, SCTE_HLS_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestName;

    private final String childManifestName;

    private final ScteHls scteHls;

    private final Integer manifestWindowSeconds;

    private final Integer programDateTimeIntervalSeconds;

    private CreateHlsManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.childManifestName = builder.childManifestName;
        this.scteHls = builder.scteHls;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
    }

    /**
     * <p>
     * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
     * automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS
     * manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you
     * provided on the originEndpoint object.
     * </p>
     * 
     * @return A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
     *         automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you
     *         use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the
     *         manifestName you provided on the originEndpoint object.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * <p>
     * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
     * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index, with an added suffix to
     * distinguish it from the manifest name. The manifestName on the HLSManifest object overrides the manifestName you
     * provided on the originEndpoint object.
     * </p>
     * 
     * @return A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
     *         endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index, with an added
     *         suffix to distinguish it from the manifest name. The manifestName on the HLSManifest object overrides the
     *         manifestName you provided on the originEndpoint object.
     */
    public final String childManifestName() {
        return childManifestName;
    }

    /**
     * Returns the value of the ScteHls property for this object.
     * 
     * @return The value of the ScteHls property for this object.
     */
    public final ScteHls scteHls() {
        return scteHls;
    }

    /**
     * <p>
     * The total duration (in seconds) of the manifest's content.
     * </p>
     * 
     * @return The total duration (in seconds) of the manifest's content.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * <p>
     * Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter
     * an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the stream to the wall
     * clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata
     * messages generate every 5 seconds whenever the content is ingested.
     * </p>
     * <p>
     * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS
     * output.
     * </p>
     * 
     * @return Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you
     *         don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the
     *         stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the
     *         player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
     *         <p>
     *         Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the
     *         HLS output.
     */
    public final Integer programDateTimeIntervalSeconds() {
        return programDateTimeIntervalSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(childManifestName());
        hashCode = 31 * hashCode + Objects.hashCode(scteHls());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeIntervalSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHlsManifestConfiguration)) {
            return false;
        }
        CreateHlsManifestConfiguration other = (CreateHlsManifestConfiguration) obj;
        return Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(childManifestName(), other.childManifestName()) && Objects.equals(scteHls(), other.scteHls())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHlsManifestConfiguration").add("ManifestName", manifestName())
                .add("ChildManifestName", childManifestName()).add("ScteHls", scteHls())
                .add("ManifestWindowSeconds", manifestWindowSeconds())
                .add("ProgramDateTimeIntervalSeconds", programDateTimeIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "ChildManifestName":
            return Optional.ofNullable(clazz.cast(childManifestName()));
        case "ScteHls":
            return Optional.ofNullable(clazz.cast(scteHls()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "ProgramDateTimeIntervalSeconds":
            return Optional.ofNullable(clazz.cast(programDateTimeIntervalSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHlsManifestConfiguration, T> g) {
        return obj -> g.apply((CreateHlsManifestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateHlsManifestConfiguration> {
        /**
         * <p>
         * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this
         * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage
         * automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use
         * HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the
         * manifestName you provided on the originEndpoint object.
         * </p>
         * 
         * @param manifestName
         *        A short short string that's appended to the endpoint URL. The manifest name creates a unique path to
         *        this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
         *        MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same
         *        manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the
         *        HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * <p>
         * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this
         * endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index, with an added
         * suffix to distinguish it from the manifest name. The manifestName on the HLSManifest object overrides the
         * manifestName you provided on the originEndpoint object.
         * </p>
         * 
         * @param childManifestName
         *        A short string that's appended to the endpoint URL. The child manifest name creates a unique path to
         *        this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index, with an
         *        added suffix to distinguish it from the manifest name. The manifestName on the HLSManifest object
         *        overrides the manifestName you provided on the originEndpoint object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childManifestName(String childManifestName);

        /**
         * Sets the value of the ScteHls property for this object.
         *
         * @param scteHls
         *        The new value for the ScteHls property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scteHls(ScteHls scteHls);

        /**
         * Sets the value of the ScteHls property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScteHls.Builder} avoiding the need to
         * create one manually via {@link ScteHls#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScteHls.Builder#build()} is called immediately and its result is
         * passed to {@link #scteHls(ScteHls)}.
         * 
         * @param scteHls
         *        a consumer that will call methods on {@link ScteHls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scteHls(ScteHls)
         */
        default Builder scteHls(Consumer<ScteHls.Builder> scteHls) {
            return scteHls(ScteHls.builder().applyMutation(scteHls).build());
        }

        /**
         * <p>
         * The total duration (in seconds) of the manifest's content.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of the manifest's content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * <p>
         * Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't
         * enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the stream to
         * the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed
         * metadata messages generate every 5 seconds whenever the content is ingested.
         * </p>
         * <p>
         * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS
         * output.
         * </p>
         * 
         * @param programDateTimeIntervalSeconds
         *        Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you
         *        don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync
         *        the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on
         *        the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.</p>
         *        <p>
         *        Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to
         *        the HLS output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String manifestName;

        private String childManifestName;

        private ScteHls scteHls;

        private Integer manifestWindowSeconds;

        private Integer programDateTimeIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHlsManifestConfiguration model) {
            manifestName(model.manifestName);
            childManifestName(model.childManifestName);
            scteHls(model.scteHls);
            manifestWindowSeconds(model.manifestWindowSeconds);
            programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getChildManifestName() {
            return childManifestName;
        }

        public final void setChildManifestName(String childManifestName) {
            this.childManifestName = childManifestName;
        }

        @Override
        public final Builder childManifestName(String childManifestName) {
            this.childManifestName = childManifestName;
            return this;
        }

        public final ScteHls.Builder getScteHls() {
            return scteHls != null ? scteHls.toBuilder() : null;
        }

        public final void setScteHls(ScteHls.BuilderImpl scteHls) {
            this.scteHls = scteHls != null ? scteHls.build() : null;
        }

        @Override
        public final Builder scteHls(ScteHls scteHls) {
            this.scteHls = scteHls;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return programDateTimeIntervalSeconds;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        @Override
        public CreateHlsManifestConfiguration build() {
            return new CreateHlsManifestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
