/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TsEncryptionMethod {
    AES_128("AES_128"),
    SAMPLE_AES("SAMPLE_AES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TsEncryptionMethod> VALUE_MAP;
    private final String value;

    private TsEncryptionMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TsEncryptionMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TsEncryptionMethod> knownValues() {
        EnumSet<TsEncryptionMethod> knownValues = EnumSet.allOf(TsEncryptionMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TsEncryptionMethod.class, TsEncryptionMethod::toString);
    }
}

