/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.EncryptionMethod;
import software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Encryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Encryption> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantInitializationVector").getter(Encryption.getter(Encryption::constantInitializationVector)).setter(Encryption.setter(Builder::constantInitializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantInitializationVector").build()}).build();
    private static final SdkField<EncryptionMethod> ENCRYPTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionMethod").getter(Encryption.getter(Encryption::encryptionMethod)).setter(Encryption.setter(Builder::encryptionMethod)).constructor(EncryptionMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMethod").build()}).build();
    private static final SdkField<Integer> KEY_ROTATION_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("KeyRotationIntervalSeconds").getter(Encryption.getter(Encryption::keyRotationIntervalSeconds)).setter(Encryption.setter(Builder::keyRotationIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRotationIntervalSeconds").build()}).build();
    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpekeKeyProvider").getter(Encryption.getter(Encryption::spekeKeyProvider)).setter(Encryption.setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpekeKeyProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, KEY_ROTATION_INTERVAL_SECONDS_FIELD, SPEKE_KEY_PROVIDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String constantInitializationVector;
    private final EncryptionMethod encryptionMethod;
    private final Integer keyRotationIntervalSeconds;
    private final SpekeKeyProvider spekeKeyProvider;

    private Encryption(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    public final String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public final EncryptionMethod encryptionMethod() {
        return this.encryptionMethod;
    }

    public final Integer keyRotationIntervalSeconds() {
        return this.keyRotationIntervalSeconds;
    }

    public final SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption)obj;
        return Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.encryptionMethod(), other.encryptionMethod()) && Objects.equals(this.keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider());
    }

    public final String toString() {
        return ToString.builder((String)"Encryption").add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("EncryptionMethod", (Object)this.encryptionMethod()).add("KeyRotationIntervalSeconds", (Object)this.keyRotationIntervalSeconds()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantInitializationVector": {
                return Optional.ofNullable(clazz.cast(this.constantInitializationVector()));
            }
            case "EncryptionMethod": {
                return Optional.ofNullable(clazz.cast(this.encryptionMethod()));
            }
            case "KeyRotationIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.keyRotationIntervalSeconds()));
            }
            case "SpekeKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.spekeKeyProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Encryption, T> g) {
        return obj -> g.apply((Encryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantInitializationVector;
        private EncryptionMethod encryptionMethod;
        private Integer keyRotationIntervalSeconds;
        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(Encryption model) {
            this.constantInitializationVector(model.constantInitializationVector);
            this.encryptionMethod(model.encryptionMethod);
            this.keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            this.spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final EncryptionMethod.Builder getEncryptionMethod() {
            return this.encryptionMethod != null ? this.encryptionMethod.toBuilder() : null;
        }

        public final void setEncryptionMethod(EncryptionMethod.BuilderImpl encryptionMethod) {
            this.encryptionMethod = encryptionMethod != null ? encryptionMethod.build() : null;
        }

        @Override
        public final Builder encryptionMethod(EncryptionMethod encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return this.keyRotationIntervalSeconds;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public Encryption build() {
            return new Encryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Encryption> {
        public Builder constantInitializationVector(String var1);

        public Builder encryptionMethod(EncryptionMethod var1);

        default public Builder encryptionMethod(Consumer<EncryptionMethod.Builder> encryptionMethod) {
            return this.encryptionMethod((EncryptionMethod)((EncryptionMethod.Builder)EncryptionMethod.builder().applyMutation(encryptionMethod)).build());
        }

        public Builder keyRotationIntervalSeconds(Integer var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().applyMutation(spekeKeyProvider)).build());
        }
    }
}

