/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.MssEncryption;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MssPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MssPackage> {
    private static final SdkField<MssEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(MssPackage.getter(MssPackage::encryption)).setter(MssPackage.setter(Builder::encryption)).constructor(MssEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManifestWindowSeconds").getter(MssPackage.getter(MssPackage::manifestWindowSeconds)).setter(MssPackage.setter(Builder::manifestWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestWindowSeconds").build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(MssPackage.getter(MssPackage::segmentDurationSeconds)).setter(MssPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSelection").getter(MssPackage.getter(MssPackage::streamSelection)).setter(MssPackage.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, STREAM_SELECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MssPackage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MssEncryption encryption;
    private final Integer manifestWindowSeconds;
    private final Integer segmentDurationSeconds;
    private final StreamSelection streamSelection;

    private MssPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
    }

    public final MssEncryption encryption() {
        return this.encryption;
    }

    public final Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public final Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public final StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.streamSelection(), other.streamSelection());
    }

    public final String toString() {
        return ToString.builder((String)"MssPackage").add("Encryption", (Object)this.encryption()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("StreamSelection", (Object)this.streamSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "ManifestWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.manifestWindowSeconds()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("manifestWindowSeconds", MANIFEST_WINDOW_SECONDS_FIELD);
        map.put("segmentDurationSeconds", SEGMENT_DURATION_SECONDS_FIELD);
        map.put("streamSelection", STREAM_SELECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MssPackage, T> g) {
        return obj -> g.apply((MssPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MssEncryption encryption;
        private Integer manifestWindowSeconds;
        private Integer segmentDurationSeconds;
        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(MssPackage model) {
            this.encryption(model.encryption);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.streamSelection(model.streamSelection);
        }

        public final MssEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(MssEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(MssEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public MssPackage build() {
            return new MssPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MssPackage> {
        public Builder encryption(MssEncryption var1);

        default public Builder encryption(Consumer<MssEncryption.Builder> encryption) {
            return this.encryption((MssEncryption)((MssEncryption.Builder)MssEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder manifestWindowSeconds(Integer var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }
    }
}

