/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.CmafEncryption;
import software.amazon.awssdk.services.mediapackage.model.HlsManifest;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.services.mediapackage.model.___listOfHlsManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafPackage> {
    private static final SdkField<CmafEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(CmafPackage.getter(CmafPackage::encryption)).setter(CmafPackage.setter(Builder::encryption)).constructor(CmafEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<List<HlsManifest>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsManifests").getter(CmafPackage.getter(CmafPackage::hlsManifests)).setter(CmafPackage.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(CmafPackage.getter(CmafPackage::segmentDurationSeconds)).setter(CmafPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<String> SEGMENT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentPrefix").getter(CmafPackage.getter(CmafPackage::segmentPrefix)).setter(CmafPackage.setter(Builder::segmentPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentPrefix").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSelection").getter(CmafPackage.getter(CmafPackage::streamSelection)).setter(CmafPackage.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, HLS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_PREFIX_FIELD, STREAM_SELECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CmafEncryption encryption;
    private final List<HlsManifest> hlsManifests;
    private final Integer segmentDurationSeconds;
    private final String segmentPrefix;
    private final StreamSelection streamSelection;

    private CmafPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.hlsManifests = builder.hlsManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentPrefix = builder.segmentPrefix;
        this.streamSelection = builder.streamSelection;
    }

    public final CmafEncryption encryption() {
        return this.encryption;
    }

    public final boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public final List<HlsManifest> hlsManifests() {
        return this.hlsManifests;
    }

    public final Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public final String segmentPrefix() {
        return this.segmentPrefix;
    }

    public final StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsManifests() ? this.hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafPackage)) {
            return false;
        }
        CmafPackage other = (CmafPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && this.hasHlsManifests() == other.hasHlsManifests() && Objects.equals(this.hlsManifests(), other.hlsManifests()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.segmentPrefix(), other.segmentPrefix()) && Objects.equals(this.streamSelection(), other.streamSelection());
    }

    public final String toString() {
        return ToString.builder((String)"CmafPackage").add("Encryption", (Object)this.encryption()).add("HlsManifests", this.hasHlsManifests() ? this.hlsManifests() : null).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("SegmentPrefix", (Object)this.segmentPrefix()).add("StreamSelection", (Object)this.streamSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "SegmentPrefix": {
                return Optional.ofNullable(clazz.cast(this.segmentPrefix()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafPackage, T> g) {
        return obj -> g.apply((CmafPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CmafEncryption encryption;
        private List<HlsManifest> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private Integer segmentDurationSeconds;
        private String segmentPrefix;
        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafPackage model) {
            this.encryption(model.encryption);
            this.hlsManifests(model.hlsManifests);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.segmentPrefix(model.segmentPrefix);
            this.streamSelection(model.streamSelection);
        }

        public final CmafEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<HlsManifest.Builder> getHlsManifests() {
            if (this.hlsManifests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hlsManifests != null ? (Collection)this.hlsManifests.stream().map(HlsManifest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hlsManifests(Collection<HlsManifest> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HlsManifest ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HlsManifest.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (HlsManifest)((HlsManifest.Builder)HlsManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHlsManifests(Collection<HlsManifest.BuilderImpl> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copyFromBuilder(hlsManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentPrefix() {
            return this.segmentPrefix;
        }

        @Override
        public final Builder segmentPrefix(String segmentPrefix) {
            this.segmentPrefix = segmentPrefix;
            return this;
        }

        public final void setSegmentPrefix(String segmentPrefix) {
            this.segmentPrefix = segmentPrefix;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public CmafPackage build() {
            return new CmafPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafPackage> {
        public Builder encryption(CmafEncryption var1);

        default public Builder encryption(Consumer<CmafEncryption.Builder> encryption) {
            return this.encryption((CmafEncryption)((CmafEncryption.Builder)CmafEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder hlsManifests(Collection<HlsManifest> var1);

        public Builder hlsManifests(HlsManifest ... var1);

        public Builder hlsManifests(Consumer<HlsManifest.Builder> ... var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder segmentPrefix(String var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }
    }
}

