/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.AdTriggersCopier;
import software.amazon.awssdk.services.mediapackage.model.AdTriggersElement;
import software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions;
import software.amazon.awssdk.services.mediapackage.model.DashEncryption;
import software.amazon.awssdk.services.mediapackage.model.ManifestLayout;
import software.amazon.awssdk.services.mediapackage.model.PeriodTriggersElement;
import software.amazon.awssdk.services.mediapackage.model.Profile;
import software.amazon.awssdk.services.mediapackage.model.SegmentTemplateFormat;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.services.mediapackage.model.UtcTiming;
import software.amazon.awssdk.services.mediapackage.model.___listOf__PeriodTriggersElementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashPackage> {
    private static final SdkField<List<String>> AD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdTriggers").getter(DashPackage.getter(DashPackage::adTriggersAsStrings)).setter(DashPackage.setter(Builder::adTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADS_ON_DELIVERY_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdsOnDeliveryRestrictions").getter(DashPackage.getter(DashPackage::adsOnDeliveryRestrictionsAsString)).setter(DashPackage.setter(Builder::adsOnDeliveryRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsOnDeliveryRestrictions").build()}).build();
    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(DashPackage.getter(DashPackage::encryption)).setter(DashPackage.setter(Builder::encryption)).constructor(DashEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> MANIFEST_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestLayout").getter(DashPackage.getter(DashPackage::manifestLayoutAsString)).setter(DashPackage.setter(Builder::manifestLayout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestLayout").build()}).build();
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManifestWindowSeconds").getter(DashPackage.getter(DashPackage::manifestWindowSeconds)).setter(DashPackage.setter(Builder::manifestWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestWindowSeconds").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTimeSeconds").getter(DashPackage.getter(DashPackage::minBufferTimeSeconds)).setter(DashPackage.setter(Builder::minBufferTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTimeSeconds").build()}).build();
    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinUpdatePeriodSeconds").getter(DashPackage.getter(DashPackage::minUpdatePeriodSeconds)).setter(DashPackage.setter(Builder::minUpdatePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minUpdatePeriodSeconds").build()}).build();
    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PeriodTriggers").getter(DashPackage.getter(DashPackage::periodTriggersAsStrings)).setter(DashPackage.setter(Builder::periodTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(DashPackage.getter(DashPackage::profileAsString)).setter(DashPackage.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(DashPackage.getter(DashPackage::segmentDurationSeconds)).setter(DashPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentTemplateFormat").getter(DashPackage.getter(DashPackage::segmentTemplateFormatAsString)).setter(DashPackage.setter(Builder::segmentTemplateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentTemplateFormat").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSelection").getter(DashPackage.getter(DashPackage::streamSelection)).setter(DashPackage.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuggestedPresentationDelaySeconds").getter(DashPackage.getter(DashPackage::suggestedPresentationDelaySeconds)).setter(DashPackage.setter(Builder::suggestedPresentationDelaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedPresentationDelaySeconds").build()}).build();
    private static final SdkField<String> UTC_TIMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtcTiming").getter(DashPackage.getter(DashPackage::utcTimingAsString)).setter(DashPackage.setter(Builder::utcTiming)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utcTiming").build()}).build();
    private static final SdkField<String> UTC_TIMING_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtcTimingUri").getter(DashPackage.getter(DashPackage::utcTimingUri)).setter(DashPackage.setter(Builder::utcTimingUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utcTimingUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_TRIGGERS_FIELD, ADS_ON_DELIVERY_RESTRICTIONS_FIELD, ENCRYPTION_FIELD, MANIFEST_LAYOUT_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, MIN_BUFFER_TIME_SECONDS_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD, PERIOD_TRIGGERS_FIELD, PROFILE_FIELD, SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD, STREAM_SELECTION_FIELD, SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD, UTC_TIMING_FIELD, UTC_TIMING_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> adTriggers;
    private final String adsOnDeliveryRestrictions;
    private final DashEncryption encryption;
    private final String manifestLayout;
    private final Integer manifestWindowSeconds;
    private final Integer minBufferTimeSeconds;
    private final Integer minUpdatePeriodSeconds;
    private final List<String> periodTriggers;
    private final String profile;
    private final Integer segmentDurationSeconds;
    private final String segmentTemplateFormat;
    private final StreamSelection streamSelection;
    private final Integer suggestedPresentationDelaySeconds;
    private final String utcTiming;
    private final String utcTimingUri;

    private DashPackage(BuilderImpl builder) {
        this.adTriggers = builder.adTriggers;
        this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
        this.encryption = builder.encryption;
        this.manifestLayout = builder.manifestLayout;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.periodTriggers = builder.periodTriggers;
        this.profile = builder.profile;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
        this.streamSelection = builder.streamSelection;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
        this.utcTiming = builder.utcTiming;
        this.utcTimingUri = builder.utcTimingUri;
    }

    public List<AdTriggersElement> adTriggers() {
        return AdTriggersCopier.copyStringToEnum(this.adTriggers);
    }

    public boolean hasAdTriggers() {
        return this.adTriggers != null && !(this.adTriggers instanceof SdkAutoConstructList);
    }

    public List<String> adTriggersAsStrings() {
        return this.adTriggers;
    }

    public AdsOnDeliveryRestrictions adsOnDeliveryRestrictions() {
        return AdsOnDeliveryRestrictions.fromValue(this.adsOnDeliveryRestrictions);
    }

    public String adsOnDeliveryRestrictionsAsString() {
        return this.adsOnDeliveryRestrictions;
    }

    public DashEncryption encryption() {
        return this.encryption;
    }

    public ManifestLayout manifestLayout() {
        return ManifestLayout.fromValue(this.manifestLayout);
    }

    public String manifestLayoutAsString() {
        return this.manifestLayout;
    }

    public Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public Integer minBufferTimeSeconds() {
        return this.minBufferTimeSeconds;
    }

    public Integer minUpdatePeriodSeconds() {
        return this.minUpdatePeriodSeconds;
    }

    public List<PeriodTriggersElement> periodTriggers() {
        return ___listOf__PeriodTriggersElementCopier.copyStringToEnum(this.periodTriggers);
    }

    public boolean hasPeriodTriggers() {
        return this.periodTriggers != null && !(this.periodTriggers instanceof SdkAutoConstructList);
    }

    public List<String> periodTriggersAsStrings() {
        return this.periodTriggers;
    }

    public Profile profile() {
        return Profile.fromValue(this.profile);
    }

    public String profileAsString() {
        return this.profile;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public SegmentTemplateFormat segmentTemplateFormat() {
        return SegmentTemplateFormat.fromValue(this.segmentTemplateFormat);
    }

    public String segmentTemplateFormatAsString() {
        return this.segmentTemplateFormat;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Integer suggestedPresentationDelaySeconds() {
        return this.suggestedPresentationDelaySeconds;
    }

    public UtcTiming utcTiming() {
        return UtcTiming.fromValue(this.utcTiming);
    }

    public String utcTimingAsString() {
        return this.utcTiming;
    }

    public String utcTimingUri() {
        return this.utcTimingUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsOnDeliveryRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTemplateFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestedPresentationDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.utcTimingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.utcTimingUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage)obj;
        return Objects.equals(this.adTriggersAsStrings(), other.adTriggersAsStrings()) && Objects.equals(this.adsOnDeliveryRestrictionsAsString(), other.adsOnDeliveryRestrictionsAsString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.manifestLayoutAsString(), other.manifestLayoutAsString()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.minBufferTimeSeconds(), other.minBufferTimeSeconds()) && Objects.equals(this.minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds()) && Objects.equals(this.periodTriggersAsStrings(), other.periodTriggersAsStrings()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString()) && Objects.equals(this.streamSelection(), other.streamSelection()) && Objects.equals(this.suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds()) && Objects.equals(this.utcTimingAsString(), other.utcTimingAsString()) && Objects.equals(this.utcTimingUri(), other.utcTimingUri());
    }

    public String toString() {
        return ToString.builder((String)"DashPackage").add("AdTriggers", this.adTriggersAsStrings()).add("AdsOnDeliveryRestrictions", (Object)this.adsOnDeliveryRestrictionsAsString()).add("Encryption", (Object)this.encryption()).add("ManifestLayout", (Object)this.manifestLayoutAsString()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("MinBufferTimeSeconds", (Object)this.minBufferTimeSeconds()).add("MinUpdatePeriodSeconds", (Object)this.minUpdatePeriodSeconds()).add("PeriodTriggers", this.periodTriggersAsStrings()).add("Profile", (Object)this.profileAsString()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("SegmentTemplateFormat", (Object)this.segmentTemplateFormatAsString()).add("StreamSelection", (Object)this.streamSelection()).add("SuggestedPresentationDelaySeconds", (Object)this.suggestedPresentationDelaySeconds()).add("UtcTiming", (Object)this.utcTimingAsString()).add("UtcTimingUri", (Object)this.utcTimingUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdTriggers": {
                return Optional.ofNullable(clazz.cast(this.adTriggersAsStrings()));
            }
            case "AdsOnDeliveryRestrictions": {
                return Optional.ofNullable(clazz.cast(this.adsOnDeliveryRestrictionsAsString()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "ManifestLayout": {
                return Optional.ofNullable(clazz.cast(this.manifestLayoutAsString()));
            }
            case "ManifestWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.manifestWindowSeconds()));
            }
            case "MinBufferTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.minBufferTimeSeconds()));
            }
            case "MinUpdatePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.minUpdatePeriodSeconds()));
            }
            case "PeriodTriggers": {
                return Optional.ofNullable(clazz.cast(this.periodTriggersAsStrings()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "SegmentTemplateFormat": {
                return Optional.ofNullable(clazz.cast(this.segmentTemplateFormatAsString()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
            case "SuggestedPresentationDelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.suggestedPresentationDelaySeconds()));
            }
            case "UtcTiming": {
                return Optional.ofNullable(clazz.cast(this.utcTimingAsString()));
            }
            case "UtcTimingUri": {
                return Optional.ofNullable(clazz.cast(this.utcTimingUri()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adTriggers = DefaultSdkAutoConstructList.getInstance();
        private String adsOnDeliveryRestrictions;
        private DashEncryption encryption;
        private String manifestLayout;
        private Integer manifestWindowSeconds;
        private Integer minBufferTimeSeconds;
        private Integer minUpdatePeriodSeconds;
        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();
        private String profile;
        private Integer segmentDurationSeconds;
        private String segmentTemplateFormat;
        private StreamSelection streamSelection;
        private Integer suggestedPresentationDelaySeconds;
        private String utcTiming;
        private String utcTimingUri;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            this.adTriggersWithStrings(model.adTriggers);
            this.adsOnDeliveryRestrictions(model.adsOnDeliveryRestrictions);
            this.encryption(model.encryption);
            this.manifestLayout(model.manifestLayout);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.minBufferTimeSeconds(model.minBufferTimeSeconds);
            this.minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            this.periodTriggersWithStrings(model.periodTriggers);
            this.profile(model.profile);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.segmentTemplateFormat(model.segmentTemplateFormat);
            this.streamSelection(model.streamSelection);
            this.suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
            this.utcTiming(model.utcTiming);
            this.utcTimingUri(model.utcTimingUri);
        }

        public final Collection<String> getAdTriggers() {
            return this.adTriggers;
        }

        @Override
        public final Builder adTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggersWithStrings(String ... adTriggers) {
            this.adTriggersWithStrings(Arrays.asList(adTriggers));
            return this;
        }

        @Override
        public final Builder adTriggers(Collection<AdTriggersElement> adTriggers) {
            this.adTriggers = AdTriggersCopier.copyEnumToString(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggers(AdTriggersElement ... adTriggers) {
            this.adTriggers(Arrays.asList(adTriggers));
            return this;
        }

        public final void setAdTriggers(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
        }

        public final String getAdsOnDeliveryRestrictions() {
            return this.adsOnDeliveryRestrictions;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
            return this;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions(adsOnDeliveryRestrictions == null ? null : adsOnDeliveryRestrictions.toString());
            return this;
        }

        public final void setAdsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
        }

        public final DashEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getManifestLayout() {
            return this.manifestLayout;
        }

        @Override
        public final Builder manifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
            return this;
        }

        @Override
        public final Builder manifestLayout(ManifestLayout manifestLayout) {
            this.manifestLayout(manifestLayout == null ? null : manifestLayout.toString());
            return this;
        }

        public final void setManifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        public final Integer getMinBufferTimeSeconds() {
            return this.minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return this.minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        public final Collection<String> getPeriodTriggers() {
            return this.periodTriggers;
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String ... periodTriggers) {
            this.periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<PeriodTriggersElement> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(PeriodTriggersElement ... periodTriggers) {
            this.periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final void setPeriodTriggers(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentTemplateFormat() {
            return this.segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(SegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return this.suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        public final String getUtcTiming() {
            return this.utcTiming;
        }

        @Override
        public final Builder utcTiming(String utcTiming) {
            this.utcTiming = utcTiming;
            return this;
        }

        @Override
        public final Builder utcTiming(UtcTiming utcTiming) {
            this.utcTiming(utcTiming == null ? null : utcTiming.toString());
            return this;
        }

        public final void setUtcTiming(String utcTiming) {
            this.utcTiming = utcTiming;
        }

        public final String getUtcTimingUri() {
            return this.utcTimingUri;
        }

        @Override
        public final Builder utcTimingUri(String utcTimingUri) {
            this.utcTimingUri = utcTimingUri;
            return this;
        }

        public final void setUtcTimingUri(String utcTimingUri) {
            this.utcTimingUri = utcTimingUri;
        }

        public DashPackage build() {
            return new DashPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashPackage> {
        public Builder adTriggersWithStrings(Collection<String> var1);

        public Builder adTriggersWithStrings(String ... var1);

        public Builder adTriggers(Collection<AdTriggersElement> var1);

        public Builder adTriggers(AdTriggersElement ... var1);

        public Builder adsOnDeliveryRestrictions(String var1);

        public Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions var1);

        public Builder encryption(DashEncryption var1);

        default public Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return this.encryption((DashEncryption)((DashEncryption.Builder)DashEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder manifestLayout(String var1);

        public Builder manifestLayout(ManifestLayout var1);

        public Builder manifestWindowSeconds(Integer var1);

        public Builder minBufferTimeSeconds(Integer var1);

        public Builder minUpdatePeriodSeconds(Integer var1);

        public Builder periodTriggersWithStrings(Collection<String> var1);

        public Builder periodTriggersWithStrings(String ... var1);

        public Builder periodTriggers(Collection<PeriodTriggersElement> var1);

        public Builder periodTriggers(PeriodTriggersElement ... var1);

        public Builder profile(String var1);

        public Builder profile(Profile var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder segmentTemplateFormat(String var1);

        public Builder segmentTemplateFormat(SegmentTemplateFormat var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }

        public Builder suggestedPresentationDelaySeconds(Integer var1);

        public Builder utcTiming(String var1);

        public Builder utcTiming(UtcTiming var1);

        public Builder utcTimingUri(String var1);
    }
}

