/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackage.MediaPackageAsyncClient;
import software.amazon.awssdk.services.mediapackage.model.HarvestJob;
import software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse;

public class ListHarvestJobsPublisher
implements SdkPublisher<ListHarvestJobsResponse> {
    private final MediaPackageAsyncClient client;
    private final ListHarvestJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHarvestJobsPublisher(MediaPackageAsyncClient client, ListHarvestJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHarvestJobsPublisher(MediaPackageAsyncClient client, ListHarvestJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHarvestJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHarvestJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HarvestJob> harvestJobs() {
        Function<ListHarvestJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.harvestJobs() != null) {
                return response.harvestJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHarvestJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHarvestJobsResponseFetcher
    implements AsyncPageFetcher<ListHarvestJobsResponse> {
        private ListHarvestJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListHarvestJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHarvestJobsResponse> nextPage(ListHarvestJobsResponse previousPage) {
            if (previousPage == null) {
                return ListHarvestJobsPublisher.this.client.listHarvestJobs(ListHarvestJobsPublisher.this.firstRequest);
            }
            return ListHarvestJobsPublisher.this.client.listHarvestJobs((ListHarvestJobsRequest)((Object)ListHarvestJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

