/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OriginEndpointMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> CHANNELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DASHPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dashPackage").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsPackage").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MSSPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mssPackage").isBinary(false).build();
    private static final MarshallingInfo<Integer> STARTOVERWINDOWSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startoverWindowSeconds").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEDELAYSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeDelaySeconds").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final MarshallingInfo<List> WHITELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitelist").isBinary(false).build();
    private static final OriginEndpointMarshaller INSTANCE = new OriginEndpointMarshaller();

    private OriginEndpointMarshaller() {
    }

    public static OriginEndpointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OriginEndpoint originEndpoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)originEndpoint, (String)"originEndpoint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)originEndpoint.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.channelId(), CHANNELID_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.dashPackage(), DASHPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.hlsPackage(), HLSPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.manifestName(), MANIFESTNAME_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.mssPackage(), MSSPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.startoverWindowSeconds(), STARTOVERWINDOWSECONDS_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.timeDelaySeconds(), TIMEDELAYSECONDS_BINDING);
            protocolMarshaller.marshall((Object)originEndpoint.url(), URL_BINDING);
            protocolMarshaller.marshall(originEndpoint.whitelist(), WHITELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

