/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.HlsEncryption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsEncryptionMarshaller {
    private static final MarshallingInfo<String> CONSTANTINITIALIZATIONVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constantInitializationVector").isBinary(false).build();
    private static final MarshallingInfo<String> ENCRYPTIONMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionMethod").isBinary(false).build();
    private static final MarshallingInfo<Integer> KEYROTATIONINTERVALSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyRotationIntervalSeconds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REPEATEXTXKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repeatExtXKey").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spekeKeyProvider").isBinary(false).build();
    private static final HlsEncryptionMarshaller INSTANCE = new HlsEncryptionMarshaller();

    private HlsEncryptionMarshaller() {
    }

    public static HlsEncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsEncryption hlsEncryption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsEncryption, (String)"hlsEncryption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsEncryption.constantInitializationVector(), CONSTANTINITIALIZATIONVECTOR_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryption.encryptionMethodString(), ENCRYPTIONMETHOD_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryption.keyRotationIntervalSeconds(), KEYROTATIONINTERVALSECONDS_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryption.repeatExtXKey(), REPEATEXTXKEY_BINDING);
            protocolMarshaller.marshall((Object)hlsEncryption.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

