/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.mediapackage.MediaPackageAsyncClient;
import software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;

public class ListOriginEndpointsPublisher
implements SdkPublisher<ListOriginEndpointsResponse> {
    private final MediaPackageAsyncClient client;
    private final ListOriginEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOriginEndpointsPublisher(MediaPackageAsyncClient client, ListOriginEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOriginEndpointsPublisher(MediaPackageAsyncClient client, ListOriginEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOriginEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOriginEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<OriginEndpoint> originEndpoints() {
        Function<ListOriginEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.originEndpoints() != null) {
                return response.originEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListOriginEndpointsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListOriginEndpointsPublisher resume(ListOriginEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOriginEndpointsPublisher(this.client, (ListOriginEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListOriginEndpointsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListOriginEndpointsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListOriginEndpointsResponseFetcher
    implements AsyncPageFetcher<ListOriginEndpointsResponse> {
        private ListOriginEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginEndpointsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListOriginEndpointsResponse> nextPage(ListOriginEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListOriginEndpointsPublisher.this.client.listOriginEndpoints(ListOriginEndpointsPublisher.this.firstRequest);
            }
            return ListOriginEndpointsPublisher.this.client.listOriginEndpoints((ListOriginEndpointsRequest)((Object)ListOriginEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

