/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;

public class StreamSelectionUnmarshaller
implements Unmarshaller<StreamSelection, JsonUnmarshallerContext> {
    private static final StreamSelectionUnmarshaller INSTANCE = new StreamSelectionUnmarshaller();

    public StreamSelection unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamSelection.Builder streamSelectionBuilder = StreamSelection.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("maxVideoBitsPerSecond", targetDepth)) {
                    context.nextToken();
                    streamSelectionBuilder.maxVideoBitsPerSecond((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minVideoBitsPerSecond", targetDepth)) {
                    context.nextToken();
                    streamSelectionBuilder.minVideoBitsPerSecond((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("streamOrder", targetDepth)) {
                    context.nextToken();
                    streamSelectionBuilder.streamOrder((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StreamSelection)streamSelectionBuilder.build();
    }

    public static StreamSelectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

