/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;
import software.amazon.awssdk.services.mediapackage.transform.DashPackageUnmarshaller;
import software.amazon.awssdk.services.mediapackage.transform.HlsPackageUnmarshaller;
import software.amazon.awssdk.services.mediapackage.transform.MssPackageUnmarshaller;

public class OriginEndpointUnmarshaller
implements Unmarshaller<OriginEndpoint, JsonUnmarshallerContext> {
    private static final OriginEndpointUnmarshaller INSTANCE = new OriginEndpointUnmarshaller();

    public OriginEndpoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        OriginEndpoint.Builder originEndpointBuilder = OriginEndpoint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("channelId", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.channelId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dashPackage", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.dashPackage(DashPackageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hlsPackage", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.hlsPackage(HlsPackageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("manifestName", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.manifestName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("mssPackage", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.mssPackage(MssPackageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("startoverWindowSeconds", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.startoverWindowSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("timeDelaySeconds", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.timeDelaySeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("url", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("whitelist", targetDepth)) {
                    context.nextToken();
                    originEndpointBuilder.whitelist(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (OriginEndpoint)originEndpointBuilder.build();
    }

    public static OriginEndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

