/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.DashPackage;
import software.amazon.awssdk.services.mediapackage.transform.DashEncryptionUnmarshaller;
import software.amazon.awssdk.services.mediapackage.transform.StreamSelectionUnmarshaller;

public class DashPackageUnmarshaller
implements Unmarshaller<DashPackage, JsonUnmarshallerContext> {
    private static final DashPackageUnmarshaller INSTANCE = new DashPackageUnmarshaller();

    public DashPackage unmarshall(JsonUnmarshallerContext context) throws Exception {
        DashPackage.Builder dashPackageBuilder = DashPackage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("encryption", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.encryption(DashEncryptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("manifestWindowSeconds", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.manifestWindowSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minBufferTimeSeconds", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.minBufferTimeSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minUpdatePeriodSeconds", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.minUpdatePeriodSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("profile", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.profile((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("segmentDurationSeconds", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.segmentDurationSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("streamSelection", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.streamSelection(StreamSelectionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("suggestedPresentationDelaySeconds", targetDepth)) {
                    context.nextToken();
                    dashPackageBuilder.suggestedPresentationDelaySeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DashPackage)dashPackageBuilder.build();
    }

    public static DashPackageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

