/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.Channel;
import software.amazon.awssdk.services.mediapackage.transform.HlsIngestUnmarshaller;

public class ChannelUnmarshaller
implements Unmarshaller<Channel, JsonUnmarshallerContext> {
    private static final ChannelUnmarshaller INSTANCE = new ChannelUnmarshaller();

    public Channel unmarshall(JsonUnmarshallerContext context) throws Exception {
        Channel.Builder channelBuilder = Channel.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    channelBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    channelBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hlsIngest", targetDepth)) {
                    context.nextToken();
                    channelBuilder.hlsIngest(HlsIngestUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    channelBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Channel)channelBuilder.build();
    }

    public static ChannelUnmarshaller getInstance() {
        return INSTANCE;
    }
}

