/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.StreamOrder;
import software.amazon.awssdk.services.mediapackage.transform.StreamSelectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamSelection
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamSelection> {
    private final Integer maxVideoBitsPerSecond;
    private final Integer minVideoBitsPerSecond;
    private final String streamOrder;

    private StreamSelection(BuilderImpl builder) {
        this.maxVideoBitsPerSecond = builder.maxVideoBitsPerSecond;
        this.minVideoBitsPerSecond = builder.minVideoBitsPerSecond;
        this.streamOrder = builder.streamOrder;
    }

    public Integer maxVideoBitsPerSecond() {
        return this.maxVideoBitsPerSecond;
    }

    public Integer minVideoBitsPerSecond() {
        return this.minVideoBitsPerSecond;
    }

    public StreamOrder streamOrder() {
        return StreamOrder.fromValue(this.streamOrder);
    }

    public String streamOrderString() {
        return this.streamOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVideoBitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.minVideoBitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamOrderString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSelection)) {
            return false;
        }
        StreamSelection other = (StreamSelection)obj;
        return Objects.equals(this.maxVideoBitsPerSecond(), other.maxVideoBitsPerSecond()) && Objects.equals(this.minVideoBitsPerSecond(), other.minVideoBitsPerSecond()) && Objects.equals(this.streamOrderString(), other.streamOrderString());
    }

    public String toString() {
        return ToString.builder((String)"StreamSelection").add("MaxVideoBitsPerSecond", (Object)this.maxVideoBitsPerSecond()).add("MinVideoBitsPerSecond", (Object)this.minVideoBitsPerSecond()).add("StreamOrder", (Object)this.streamOrderString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxVideoBitsPerSecond": {
                return Optional.of(clazz.cast(this.maxVideoBitsPerSecond()));
            }
            case "MinVideoBitsPerSecond": {
                return Optional.of(clazz.cast(this.minVideoBitsPerSecond()));
            }
            case "StreamOrder": {
                return Optional.of(clazz.cast(this.streamOrderString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxVideoBitsPerSecond;
        private Integer minVideoBitsPerSecond;
        private String streamOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSelection model) {
            this.maxVideoBitsPerSecond(model.maxVideoBitsPerSecond);
            this.minVideoBitsPerSecond(model.minVideoBitsPerSecond);
            this.streamOrder(model.streamOrder);
        }

        public final Integer getMaxVideoBitsPerSecond() {
            return this.maxVideoBitsPerSecond;
        }

        @Override
        public final Builder maxVideoBitsPerSecond(Integer maxVideoBitsPerSecond) {
            this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
            return this;
        }

        public final void setMaxVideoBitsPerSecond(Integer maxVideoBitsPerSecond) {
            this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
        }

        public final Integer getMinVideoBitsPerSecond() {
            return this.minVideoBitsPerSecond;
        }

        @Override
        public final Builder minVideoBitsPerSecond(Integer minVideoBitsPerSecond) {
            this.minVideoBitsPerSecond = minVideoBitsPerSecond;
            return this;
        }

        public final void setMinVideoBitsPerSecond(Integer minVideoBitsPerSecond) {
            this.minVideoBitsPerSecond = minVideoBitsPerSecond;
        }

        public final String getStreamOrder() {
            return this.streamOrder;
        }

        @Override
        public final Builder streamOrder(String streamOrder) {
            this.streamOrder = streamOrder;
            return this;
        }

        @Override
        public final Builder streamOrder(StreamOrder streamOrder) {
            this.streamOrder(streamOrder.toString());
            return this;
        }

        public final void setStreamOrder(String streamOrder) {
            this.streamOrder = streamOrder;
        }

        public StreamSelection build() {
            return new StreamSelection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamSelection> {
        public Builder maxVideoBitsPerSecond(Integer var1);

        public Builder minVideoBitsPerSecond(Integer var1);

        public Builder streamOrder(String var1);

        public Builder streamOrder(StreamOrder var1);
    }
}

