/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.transform.IngestEndpointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IngestEndpoint
implements StructuredPojo,
ToCopyableBuilder<Builder, IngestEndpoint> {
    private final String password;
    private final String url;
    private final String username;

    private IngestEndpoint(BuilderImpl builder) {
        this.password = builder.password;
        this.url = builder.url;
        this.username = builder.username;
    }

    public String password() {
        return this.password;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestEndpoint)) {
            return false;
        }
        IngestEndpoint other = (IngestEndpoint)obj;
        return Objects.equals(this.password(), other.password()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"IngestEndpoint").add("Password", (Object)this.password()).add("Url", (Object)this.url()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Password": {
                return Optional.of(clazz.cast(this.password()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IngestEndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String password;
        private String url;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestEndpoint model) {
            this.password(model.password);
            this.url(model.url);
            this.username(model.username);
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public IngestEndpoint build() {
            return new IngestEndpoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IngestEndpoint> {
        public Builder password(String var1);

        public Builder url(String var1);

        public Builder username(String var1);
    }
}

