/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsOutputSettings> {
    private static final SdkField<HlsSettings> HLS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HlsOutputSettings.getter(HlsOutputSettings::hlsSettings)).setter(HlsOutputSettings.setter(Builder::hlsSettings)).constructor(HlsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsSettings").build()}).build();
    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsOutputSettings.getter(HlsOutputSettings::nameModifier)).setter(HlsOutputSettings.setter(Builder::nameModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()}).build();
    private static final SdkField<String> SEGMENT_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsOutputSettings.getter(HlsOutputSettings::segmentModifier)).setter(HlsOutputSettings.setter(Builder::segmentModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentModifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_SETTINGS_FIELD, NAME_MODIFIER_FIELD, SEGMENT_MODIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final HlsSettings hlsSettings;
    private final String nameModifier;
    private final String segmentModifier;

    private HlsOutputSettings(BuilderImpl builder) {
        this.hlsSettings = builder.hlsSettings;
        this.nameModifier = builder.nameModifier;
        this.segmentModifier = builder.segmentModifier;
    }

    public HlsSettings hlsSettings() {
        return this.hlsSettings;
    }

    public String nameModifier() {
        return this.nameModifier;
    }

    public String segmentModifier() {
        return this.segmentModifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentModifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsOutputSettings)) {
            return false;
        }
        HlsOutputSettings other = (HlsOutputSettings)obj;
        return Objects.equals(this.hlsSettings(), other.hlsSettings()) && Objects.equals(this.nameModifier(), other.nameModifier()) && Objects.equals(this.segmentModifier(), other.segmentModifier());
    }

    public String toString() {
        return ToString.builder((String)"HlsOutputSettings").add("HlsSettings", (Object)this.hlsSettings()).add("NameModifier", (Object)this.nameModifier()).add("SegmentModifier", (Object)this.segmentModifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsSettings()));
            }
            case "NameModifier": {
                return Optional.ofNullable(clazz.cast(this.nameModifier()));
            }
            case "SegmentModifier": {
                return Optional.ofNullable(clazz.cast(this.segmentModifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsOutputSettings, T> g) {
        return obj -> g.apply((HlsOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsSettings hlsSettings;
        private String nameModifier;
        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsOutputSettings model) {
            this.hlsSettings(model.hlsSettings);
            this.nameModifier(model.nameModifier);
            this.segmentModifier(model.segmentModifier);
        }

        public final HlsSettings.Builder getHlsSettings() {
            return this.hlsSettings != null ? this.hlsSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsSettings(HlsSettings hlsSettings) {
            this.hlsSettings = hlsSettings;
            return this;
        }

        public final void setHlsSettings(HlsSettings.BuilderImpl hlsSettings) {
            this.hlsSettings = hlsSettings != null ? hlsSettings.build() : null;
        }

        public final String getNameModifier() {
            return this.nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        public final String getSegmentModifier() {
            return this.segmentModifier;
        }

        @Override
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        public HlsOutputSettings build() {
            return new HlsOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsOutputSettings> {
        public Builder hlsSettings(HlsSettings var1);

        default public Builder hlsSettings(Consumer<HlsSettings.Builder> hlsSettings) {
            return this.hlsSettings((HlsSettings)((HlsSettings.Builder)HlsSettings.builder().applyMutation(hlsSettings)).build());
        }

        public Builder nameModifier(String var1);

        public Builder segmentModifier(String var1);
    }
}

