/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.ChannelClass;
import software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint;
import software.amazon.awssdk.services.medialive.model.ChannelState;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.InputSpecification;
import software.amazon.awssdk.services.medialive.model.LogLevel;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfChannelEgressEndpointCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::arn)).setter(Channel.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::channelClassAsString)).setter(Channel.setter(Builder::channelClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()}).build();
    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Channel.getter(Channel::destinations)).setter(Channel.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ChannelEgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Channel.getter(Channel::egressEndpoints)).setter(Channel.setter(Builder::egressEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelEgressEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Channel.getter(Channel::encoderSettings)).setter(Channel.setter(Builder::encoderSettings)).constructor(EncoderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::id)).setter(Channel.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Channel.getter(Channel::inputAttachments)).setter(Channel.setter(Builder::inputAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Channel.getter(Channel::inputSpecification)).setter(Channel.setter(Builder::inputSpecification)).constructor(InputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::logLevelAsString)).setter(Channel.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::name)).setter(Channel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Channel.getter(Channel::pipelinesRunningCount)).setter(Channel.setter(Builder::pipelinesRunningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::roleArn)).setter(Channel.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::stateAsString)).setter(Channel.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Channel.getter(Channel::tags)).setter(Channel.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_CLASS_FIELD, DESTINATIONS_FIELD, EGRESS_ENDPOINTS_FIELD, ENCODER_SETTINGS_FIELD, ID_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD, NAME_FIELD, PIPELINES_RUNNING_COUNT_FIELD, ROLE_ARN_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String channelClass;
    private final List<OutputDestination> destinations;
    private final List<ChannelEgressEndpoint> egressEndpoints;
    private final EncoderSettings encoderSettings;
    private final String id;
    private final List<InputAttachment> inputAttachments;
    private final InputSpecification inputSpecification;
    private final String logLevel;
    private final String name;
    private final Integer pipelinesRunningCount;
    private final String roleArn;
    private final String state;
    private final Map<String, String> tags;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelClass = builder.channelClass;
        this.destinations = builder.destinations;
        this.egressEndpoints = builder.egressEndpoints;
        this.encoderSettings = builder.encoderSettings;
        this.id = builder.id;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public ChannelClass channelClass() {
        return ChannelClass.fromValue(this.channelClass);
    }

    public String channelClassAsString() {
        return this.channelClass;
    }

    public List<OutputDestination> destinations() {
        return this.destinations;
    }

    public List<ChannelEgressEndpoint> egressEndpoints() {
        return this.egressEndpoints;
    }

    public EncoderSettings encoderSettings() {
        return this.encoderSettings;
    }

    public String id() {
        return this.id;
    }

    public List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public InputSpecification inputSpecification() {
        return this.inputSpecification;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelAsString() {
        return this.logLevel;
    }

    public String name() {
        return this.name;
    }

    public Integer pipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public ChannelState state() {
        return ChannelState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelClassAsString(), other.channelClassAsString()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.egressEndpoints(), other.egressEndpoints()) && Objects.equals(this.encoderSettings(), other.encoderSettings()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.inputSpecification(), other.inputSpecification()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipelinesRunningCount(), other.pipelinesRunningCount()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Channel").add("Arn", (Object)this.arn()).add("ChannelClass", (Object)this.channelClassAsString()).add("Destinations", this.destinations()).add("EgressEndpoints", this.egressEndpoints()).add("EncoderSettings", (Object)this.encoderSettings()).add("Id", (Object)this.id()).add("InputAttachments", this.inputAttachments()).add("InputSpecification", (Object)this.inputSpecification()).add("LogLevel", (Object)this.logLevelAsString()).add("Name", (Object)this.name()).add("PipelinesRunningCount", (Object)this.pipelinesRunningCount()).add("RoleArn", (Object)this.roleArn()).add("State", (Object)this.stateAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelClass": {
                return Optional.ofNullable(clazz.cast(this.channelClassAsString()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "EgressEndpoints": {
                return Optional.ofNullable(clazz.cast(this.egressEndpoints()));
            }
            case "EncoderSettings": {
                return Optional.ofNullable(clazz.cast(this.encoderSettings()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InputAttachments": {
                return Optional.ofNullable(clazz.cast(this.inputAttachments()));
            }
            case "InputSpecification": {
                return Optional.ofNullable(clazz.cast(this.inputSpecification()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PipelinesRunningCount": {
                return Optional.ofNullable(clazz.cast(this.pipelinesRunningCount()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String channelClass;
        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<ChannelEgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();
        private EncoderSettings encoderSettings;
        private String id;
        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();
        private InputSpecification inputSpecification;
        private String logLevel;
        private String name;
        private Integer pipelinesRunningCount;
        private String roleArn;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.arn(model.arn);
            this.channelClass(model.channelClass);
            this.destinations(model.destinations);
            this.egressEndpoints(model.egressEndpoints);
            this.encoderSettings(model.encoderSettings);
            this.id(model.id);
            this.inputAttachments(model.inputAttachments);
            this.inputSpecification(model.inputSpecification);
            this.logLevel(model.logLevel);
            this.name(model.name);
            this.pipelinesRunningCount(model.pipelinesRunningCount);
            this.roleArn(model.roleArn);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelClassAsString() {
            return this.channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass.toString());
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final Collection<OutputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(OutputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final Collection<ChannelEgressEndpoint.Builder> getEgressEndpoints() {
            return this.egressEndpoints != null ? (Collection)this.egressEndpoints.stream().map(ChannelEgressEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(ChannelEgressEndpoint ... egressEndpoints) {
            this.egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... egressEndpoints) {
            this.egressEndpoints(Stream.of(egressEndpoints).map(c -> (ChannelEgressEndpoint)((ChannelEgressEndpoint.Builder)ChannelEgressEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEgressEndpoints(Collection<ChannelEgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return this.encoderSettings != null ? this.encoderSettings.toBuilder() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<InputAttachment.Builder> getInputAttachments() {
            return this.inputAttachments != null ? (Collection)this.inputAttachments.stream().map(InputAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        public final InputSpecification.Builder getInputSpecification() {
            return this.inputSpecification != null ? this.inputSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        public final String getLogLevelAsString() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPipelinesRunningCount() {
            return this.pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder arn(String var1);

        public Builder channelClass(String var1);

        public Builder channelClass(ChannelClass var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder egressEndpoints(Collection<ChannelEgressEndpoint> var1);

        public Builder egressEndpoints(ChannelEgressEndpoint ... var1);

        public Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... var1);

        public Builder encoderSettings(EncoderSettings var1);

        default public Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return this.encoderSettings((EncoderSettings)((EncoderSettings.Builder)EncoderSettings.builder().applyMutation(encoderSettings)).build());
        }

        public Builder id(String var1);

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder inputSpecification(InputSpecification var1);

        default public Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return this.inputSpecification((InputSpecification)((InputSpecification.Builder)InputSpecification.builder().applyMutation(inputSpecification)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder name(String var1);

        public Builder pipelinesRunningCount(Integer var1);

        public Builder roleArn(String var1);

        public Builder state(String var1);

        public Builder state(ChannelState var1);

        public Builder tags(Map<String, String> var1);
    }
}

