/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings;
import software.amazon.awssdk.services.medialive.model.OutputDestinationSettings;
import software.amazon.awssdk.services.medialive.model.___listOfMediaPackageOutputDestinationSettingsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputDestination> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputDestination.getter(OutputDestination::id)).setter(OutputDestination.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<MediaPackageOutputDestinationSettings>> MEDIA_PACKAGE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OutputDestination.getter(OutputDestination::mediaPackageSettings)).setter(OutputDestination.setter(Builder::mediaPackageSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaPackageOutputDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputDestinationSettings>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OutputDestination.getter(OutputDestination::settings)).setter(OutputDestination.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEDIA_PACKAGE_SETTINGS_FIELD, SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<MediaPackageOutputDestinationSettings> mediaPackageSettings;
    private final List<OutputDestinationSettings> settings;

    private OutputDestination(BuilderImpl builder) {
        this.id = builder.id;
        this.mediaPackageSettings = builder.mediaPackageSettings;
        this.settings = builder.settings;
    }

    public String id() {
        return this.id;
    }

    public List<MediaPackageOutputDestinationSettings> mediaPackageSettings() {
        return this.mediaPackageSettings;
    }

    public List<OutputDestinationSettings> settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPackageSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDestination)) {
            return false;
        }
        OutputDestination other = (OutputDestination)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.mediaPackageSettings(), other.mediaPackageSettings()) && Objects.equals(this.settings(), other.settings());
    }

    public String toString() {
        return ToString.builder((String)"OutputDestination").add("Id", (Object)this.id()).add("MediaPackageSettings", this.mediaPackageSettings()).add("Settings", this.settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MediaPackageSettings": {
                return Optional.ofNullable(clazz.cast(this.mediaPackageSettings()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDestination, T> g) {
        return obj -> g.apply((OutputDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<MediaPackageOutputDestinationSettings> mediaPackageSettings = DefaultSdkAutoConstructList.getInstance();
        private List<OutputDestinationSettings> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDestination model) {
            this.id(model.id);
            this.mediaPackageSettings(model.mediaPackageSettings);
            this.settings(model.settings);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<MediaPackageOutputDestinationSettings.Builder> getMediaPackageSettings() {
            return this.mediaPackageSettings != null ? (Collection)this.mediaPackageSettings.stream().map(MediaPackageOutputDestinationSettings::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaPackageSettings(Collection<MediaPackageOutputDestinationSettings> mediaPackageSettings) {
            this.mediaPackageSettings = ___listOfMediaPackageOutputDestinationSettingsCopier.copy(mediaPackageSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPackageSettings(MediaPackageOutputDestinationSettings ... mediaPackageSettings) {
            this.mediaPackageSettings(Arrays.asList(mediaPackageSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPackageSettings(Consumer<MediaPackageOutputDestinationSettings.Builder> ... mediaPackageSettings) {
            this.mediaPackageSettings(Stream.of(mediaPackageSettings).map(c -> (MediaPackageOutputDestinationSettings)((MediaPackageOutputDestinationSettings.Builder)MediaPackageOutputDestinationSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMediaPackageSettings(Collection<MediaPackageOutputDestinationSettings.BuilderImpl> mediaPackageSettings) {
            this.mediaPackageSettings = ___listOfMediaPackageOutputDestinationSettingsCopier.copyFromBuilder(mediaPackageSettings);
        }

        public final Collection<OutputDestinationSettings.Builder> getSettings() {
            return this.settings != null ? (Collection)this.settings.stream().map(OutputDestinationSettings::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder settings(Collection<OutputDestinationSettings> settings) {
            this.settings = ___listOfOutputDestinationSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(OutputDestinationSettings ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(Consumer<OutputDestinationSettings.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (OutputDestinationSettings)((OutputDestinationSettings.Builder)OutputDestinationSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSettings(Collection<OutputDestinationSettings.BuilderImpl> settings) {
            this.settings = ___listOfOutputDestinationSettingsCopier.copyFromBuilder(settings);
        }

        public OutputDestination build() {
            return new OutputDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputDestination> {
        public Builder id(String var1);

        public Builder mediaPackageSettings(Collection<MediaPackageOutputDestinationSettings> var1);

        public Builder mediaPackageSettings(MediaPackageOutputDestinationSettings ... var1);

        public Builder mediaPackageSettings(Consumer<MediaPackageOutputDestinationSettings.Builder> ... var1);

        public Builder settings(Collection<OutputDestinationSettings> var1);

        public Builder settings(OutputDestinationSettings ... var1);

        public Builder settings(Consumer<OutputDestinationSettings.Builder> ... var1);
    }
}

