/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsTimedMetadataScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.InputSwitchScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.PauseStateScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.Scte35ReturnToNetworkScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.Scte35SpliceInsertScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.Scte35TimeSignalScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.StaticImageActivateScheduleActionSettings;
import software.amazon.awssdk.services.medialive.model.StaticImageDeactivateScheduleActionSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleActionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleActionSettings> {
    private static final SdkField<HlsTimedMetadataScheduleActionSettings> HLS_TIMED_METADATA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::hlsTimedMetadataSettings)).setter(ScheduleActionSettings.setter(Builder::hlsTimedMetadataSettings)).constructor(HlsTimedMetadataScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsTimedMetadataSettings").build()}).build();
    private static final SdkField<InputSwitchScheduleActionSettings> INPUT_SWITCH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::inputSwitchSettings)).setter(ScheduleActionSettings.setter(Builder::inputSwitchSettings)).constructor(InputSwitchScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSwitchSettings").build()}).build();
    private static final SdkField<PauseStateScheduleActionSettings> PAUSE_STATE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::pauseStateSettings)).setter(ScheduleActionSettings.setter(Builder::pauseStateSettings)).constructor(PauseStateScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pauseStateSettings").build()}).build();
    private static final SdkField<Scte35ReturnToNetworkScheduleActionSettings> SCTE35_RETURN_TO_NETWORK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::scte35ReturnToNetworkSettings)).setter(ScheduleActionSettings.setter(Builder::scte35ReturnToNetworkSettings)).constructor(Scte35ReturnToNetworkScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35ReturnToNetworkSettings").build()}).build();
    private static final SdkField<Scte35SpliceInsertScheduleActionSettings> SCTE35_SPLICE_INSERT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::scte35SpliceInsertSettings)).setter(ScheduleActionSettings.setter(Builder::scte35SpliceInsertSettings)).constructor(Scte35SpliceInsertScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35SpliceInsertSettings").build()}).build();
    private static final SdkField<Scte35TimeSignalScheduleActionSettings> SCTE35_TIME_SIGNAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::scte35TimeSignalSettings)).setter(ScheduleActionSettings.setter(Builder::scte35TimeSignalSettings)).constructor(Scte35TimeSignalScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35TimeSignalSettings").build()}).build();
    private static final SdkField<StaticImageActivateScheduleActionSettings> STATIC_IMAGE_ACTIVATE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::staticImageActivateSettings)).setter(ScheduleActionSettings.setter(Builder::staticImageActivateSettings)).constructor(StaticImageActivateScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticImageActivateSettings").build()}).build();
    private static final SdkField<StaticImageDeactivateScheduleActionSettings> STATIC_IMAGE_DEACTIVATE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActionSettings.getter(ScheduleActionSettings::staticImageDeactivateSettings)).setter(ScheduleActionSettings.setter(Builder::staticImageDeactivateSettings)).constructor(StaticImageDeactivateScheduleActionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticImageDeactivateSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_TIMED_METADATA_SETTINGS_FIELD, INPUT_SWITCH_SETTINGS_FIELD, PAUSE_STATE_SETTINGS_FIELD, SCTE35_RETURN_TO_NETWORK_SETTINGS_FIELD, SCTE35_SPLICE_INSERT_SETTINGS_FIELD, SCTE35_TIME_SIGNAL_SETTINGS_FIELD, STATIC_IMAGE_ACTIVATE_SETTINGS_FIELD, STATIC_IMAGE_DEACTIVATE_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings;
    private final InputSwitchScheduleActionSettings inputSwitchSettings;
    private final PauseStateScheduleActionSettings pauseStateSettings;
    private final Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings;
    private final Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings;
    private final Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings;
    private final StaticImageActivateScheduleActionSettings staticImageActivateSettings;
    private final StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings;

    private ScheduleActionSettings(BuilderImpl builder) {
        this.hlsTimedMetadataSettings = builder.hlsTimedMetadataSettings;
        this.inputSwitchSettings = builder.inputSwitchSettings;
        this.pauseStateSettings = builder.pauseStateSettings;
        this.scte35ReturnToNetworkSettings = builder.scte35ReturnToNetworkSettings;
        this.scte35SpliceInsertSettings = builder.scte35SpliceInsertSettings;
        this.scte35TimeSignalSettings = builder.scte35TimeSignalSettings;
        this.staticImageActivateSettings = builder.staticImageActivateSettings;
        this.staticImageDeactivateSettings = builder.staticImageDeactivateSettings;
    }

    public HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings() {
        return this.hlsTimedMetadataSettings;
    }

    public InputSwitchScheduleActionSettings inputSwitchSettings() {
        return this.inputSwitchSettings;
    }

    public PauseStateScheduleActionSettings pauseStateSettings() {
        return this.pauseStateSettings;
    }

    public Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings() {
        return this.scte35ReturnToNetworkSettings;
    }

    public Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings() {
        return this.scte35SpliceInsertSettings;
    }

    public Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings() {
        return this.scte35TimeSignalSettings;
    }

    public StaticImageActivateScheduleActionSettings staticImageActivateSettings() {
        return this.staticImageActivateSettings;
    }

    public StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings() {
        return this.staticImageDeactivateSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsTimedMetadataSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSwitchSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.pauseStateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35ReturnToNetworkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SpliceInsertSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35TimeSignalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticImageActivateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticImageDeactivateSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActionSettings)) {
            return false;
        }
        ScheduleActionSettings other = (ScheduleActionSettings)obj;
        return Objects.equals(this.hlsTimedMetadataSettings(), other.hlsTimedMetadataSettings()) && Objects.equals(this.inputSwitchSettings(), other.inputSwitchSettings()) && Objects.equals(this.pauseStateSettings(), other.pauseStateSettings()) && Objects.equals(this.scte35ReturnToNetworkSettings(), other.scte35ReturnToNetworkSettings()) && Objects.equals(this.scte35SpliceInsertSettings(), other.scte35SpliceInsertSettings()) && Objects.equals(this.scte35TimeSignalSettings(), other.scte35TimeSignalSettings()) && Objects.equals(this.staticImageActivateSettings(), other.staticImageActivateSettings()) && Objects.equals(this.staticImageDeactivateSettings(), other.staticImageDeactivateSettings());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleActionSettings").add("HlsTimedMetadataSettings", (Object)this.hlsTimedMetadataSettings()).add("InputSwitchSettings", (Object)this.inputSwitchSettings()).add("PauseStateSettings", (Object)this.pauseStateSettings()).add("Scte35ReturnToNetworkSettings", (Object)this.scte35ReturnToNetworkSettings()).add("Scte35SpliceInsertSettings", (Object)this.scte35SpliceInsertSettings()).add("Scte35TimeSignalSettings", (Object)this.scte35TimeSignalSettings()).add("StaticImageActivateSettings", (Object)this.staticImageActivateSettings()).add("StaticImageDeactivateSettings", (Object)this.staticImageDeactivateSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsTimedMetadataSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsTimedMetadataSettings()));
            }
            case "InputSwitchSettings": {
                return Optional.ofNullable(clazz.cast(this.inputSwitchSettings()));
            }
            case "PauseStateSettings": {
                return Optional.ofNullable(clazz.cast(this.pauseStateSettings()));
            }
            case "Scte35ReturnToNetworkSettings": {
                return Optional.ofNullable(clazz.cast(this.scte35ReturnToNetworkSettings()));
            }
            case "Scte35SpliceInsertSettings": {
                return Optional.ofNullable(clazz.cast(this.scte35SpliceInsertSettings()));
            }
            case "Scte35TimeSignalSettings": {
                return Optional.ofNullable(clazz.cast(this.scte35TimeSignalSettings()));
            }
            case "StaticImageActivateSettings": {
                return Optional.ofNullable(clazz.cast(this.staticImageActivateSettings()));
            }
            case "StaticImageDeactivateSettings": {
                return Optional.ofNullable(clazz.cast(this.staticImageDeactivateSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleActionSettings, T> g) {
        return obj -> g.apply((ScheduleActionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings;
        private InputSwitchScheduleActionSettings inputSwitchSettings;
        private PauseStateScheduleActionSettings pauseStateSettings;
        private Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings;
        private Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings;
        private Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings;
        private StaticImageActivateScheduleActionSettings staticImageActivateSettings;
        private StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActionSettings model) {
            this.hlsTimedMetadataSettings(model.hlsTimedMetadataSettings);
            this.inputSwitchSettings(model.inputSwitchSettings);
            this.pauseStateSettings(model.pauseStateSettings);
            this.scte35ReturnToNetworkSettings(model.scte35ReturnToNetworkSettings);
            this.scte35SpliceInsertSettings(model.scte35SpliceInsertSettings);
            this.scte35TimeSignalSettings(model.scte35TimeSignalSettings);
            this.staticImageActivateSettings(model.staticImageActivateSettings);
            this.staticImageDeactivateSettings(model.staticImageDeactivateSettings);
        }

        public final HlsTimedMetadataScheduleActionSettings.Builder getHlsTimedMetadataSettings() {
            return this.hlsTimedMetadataSettings != null ? this.hlsTimedMetadataSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings) {
            this.hlsTimedMetadataSettings = hlsTimedMetadataSettings;
            return this;
        }

        public final void setHlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings.BuilderImpl hlsTimedMetadataSettings) {
            this.hlsTimedMetadataSettings = hlsTimedMetadataSettings != null ? hlsTimedMetadataSettings.build() : null;
        }

        public final InputSwitchScheduleActionSettings.Builder getInputSwitchSettings() {
            return this.inputSwitchSettings != null ? this.inputSwitchSettings.toBuilder() : null;
        }

        @Override
        public final Builder inputSwitchSettings(InputSwitchScheduleActionSettings inputSwitchSettings) {
            this.inputSwitchSettings = inputSwitchSettings;
            return this;
        }

        public final void setInputSwitchSettings(InputSwitchScheduleActionSettings.BuilderImpl inputSwitchSettings) {
            this.inputSwitchSettings = inputSwitchSettings != null ? inputSwitchSettings.build() : null;
        }

        public final PauseStateScheduleActionSettings.Builder getPauseStateSettings() {
            return this.pauseStateSettings != null ? this.pauseStateSettings.toBuilder() : null;
        }

        @Override
        public final Builder pauseStateSettings(PauseStateScheduleActionSettings pauseStateSettings) {
            this.pauseStateSettings = pauseStateSettings;
            return this;
        }

        public final void setPauseStateSettings(PauseStateScheduleActionSettings.BuilderImpl pauseStateSettings) {
            this.pauseStateSettings = pauseStateSettings != null ? pauseStateSettings.build() : null;
        }

        public final Scte35ReturnToNetworkScheduleActionSettings.Builder getScte35ReturnToNetworkSettings() {
            return this.scte35ReturnToNetworkSettings != null ? this.scte35ReturnToNetworkSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings) {
            this.scte35ReturnToNetworkSettings = scte35ReturnToNetworkSettings;
            return this;
        }

        public final void setScte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings.BuilderImpl scte35ReturnToNetworkSettings) {
            this.scte35ReturnToNetworkSettings = scte35ReturnToNetworkSettings != null ? scte35ReturnToNetworkSettings.build() : null;
        }

        public final Scte35SpliceInsertScheduleActionSettings.Builder getScte35SpliceInsertSettings() {
            return this.scte35SpliceInsertSettings != null ? this.scte35SpliceInsertSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings) {
            this.scte35SpliceInsertSettings = scte35SpliceInsertSettings;
            return this;
        }

        public final void setScte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings.BuilderImpl scte35SpliceInsertSettings) {
            this.scte35SpliceInsertSettings = scte35SpliceInsertSettings != null ? scte35SpliceInsertSettings.build() : null;
        }

        public final Scte35TimeSignalScheduleActionSettings.Builder getScte35TimeSignalSettings() {
            return this.scte35TimeSignalSettings != null ? this.scte35TimeSignalSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings) {
            this.scte35TimeSignalSettings = scte35TimeSignalSettings;
            return this;
        }

        public final void setScte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings.BuilderImpl scte35TimeSignalSettings) {
            this.scte35TimeSignalSettings = scte35TimeSignalSettings != null ? scte35TimeSignalSettings.build() : null;
        }

        public final StaticImageActivateScheduleActionSettings.Builder getStaticImageActivateSettings() {
            return this.staticImageActivateSettings != null ? this.staticImageActivateSettings.toBuilder() : null;
        }

        @Override
        public final Builder staticImageActivateSettings(StaticImageActivateScheduleActionSettings staticImageActivateSettings) {
            this.staticImageActivateSettings = staticImageActivateSettings;
            return this;
        }

        public final void setStaticImageActivateSettings(StaticImageActivateScheduleActionSettings.BuilderImpl staticImageActivateSettings) {
            this.staticImageActivateSettings = staticImageActivateSettings != null ? staticImageActivateSettings.build() : null;
        }

        public final StaticImageDeactivateScheduleActionSettings.Builder getStaticImageDeactivateSettings() {
            return this.staticImageDeactivateSettings != null ? this.staticImageDeactivateSettings.toBuilder() : null;
        }

        @Override
        public final Builder staticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings) {
            this.staticImageDeactivateSettings = staticImageDeactivateSettings;
            return this;
        }

        public final void setStaticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings.BuilderImpl staticImageDeactivateSettings) {
            this.staticImageDeactivateSettings = staticImageDeactivateSettings != null ? staticImageDeactivateSettings.build() : null;
        }

        public ScheduleActionSettings build() {
            return new ScheduleActionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleActionSettings> {
        public Builder hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings var1);

        default public Builder hlsTimedMetadataSettings(Consumer<HlsTimedMetadataScheduleActionSettings.Builder> hlsTimedMetadataSettings) {
            return this.hlsTimedMetadataSettings((HlsTimedMetadataScheduleActionSettings)((HlsTimedMetadataScheduleActionSettings.Builder)HlsTimedMetadataScheduleActionSettings.builder().applyMutation(hlsTimedMetadataSettings)).build());
        }

        public Builder inputSwitchSettings(InputSwitchScheduleActionSettings var1);

        default public Builder inputSwitchSettings(Consumer<InputSwitchScheduleActionSettings.Builder> inputSwitchSettings) {
            return this.inputSwitchSettings((InputSwitchScheduleActionSettings)((InputSwitchScheduleActionSettings.Builder)InputSwitchScheduleActionSettings.builder().applyMutation(inputSwitchSettings)).build());
        }

        public Builder pauseStateSettings(PauseStateScheduleActionSettings var1);

        default public Builder pauseStateSettings(Consumer<PauseStateScheduleActionSettings.Builder> pauseStateSettings) {
            return this.pauseStateSettings((PauseStateScheduleActionSettings)((PauseStateScheduleActionSettings.Builder)PauseStateScheduleActionSettings.builder().applyMutation(pauseStateSettings)).build());
        }

        public Builder scte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings var1);

        default public Builder scte35ReturnToNetworkSettings(Consumer<Scte35ReturnToNetworkScheduleActionSettings.Builder> scte35ReturnToNetworkSettings) {
            return this.scte35ReturnToNetworkSettings((Scte35ReturnToNetworkScheduleActionSettings)((Scte35ReturnToNetworkScheduleActionSettings.Builder)Scte35ReturnToNetworkScheduleActionSettings.builder().applyMutation(scte35ReturnToNetworkSettings)).build());
        }

        public Builder scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings var1);

        default public Builder scte35SpliceInsertSettings(Consumer<Scte35SpliceInsertScheduleActionSettings.Builder> scte35SpliceInsertSettings) {
            return this.scte35SpliceInsertSettings((Scte35SpliceInsertScheduleActionSettings)((Scte35SpliceInsertScheduleActionSettings.Builder)Scte35SpliceInsertScheduleActionSettings.builder().applyMutation(scte35SpliceInsertSettings)).build());
        }

        public Builder scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings var1);

        default public Builder scte35TimeSignalSettings(Consumer<Scte35TimeSignalScheduleActionSettings.Builder> scte35TimeSignalSettings) {
            return this.scte35TimeSignalSettings((Scte35TimeSignalScheduleActionSettings)((Scte35TimeSignalScheduleActionSettings.Builder)Scte35TimeSignalScheduleActionSettings.builder().applyMutation(scte35TimeSignalSettings)).build());
        }

        public Builder staticImageActivateSettings(StaticImageActivateScheduleActionSettings var1);

        default public Builder staticImageActivateSettings(Consumer<StaticImageActivateScheduleActionSettings.Builder> staticImageActivateSettings) {
            return this.staticImageActivateSettings((StaticImageActivateScheduleActionSettings)((StaticImageActivateScheduleActionSettings.Builder)StaticImageActivateScheduleActionSettings.builder().applyMutation(staticImageActivateSettings)).build());
        }

        public Builder staticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings var1);

        default public Builder staticImageDeactivateSettings(Consumer<StaticImageDeactivateScheduleActionSettings.Builder> staticImageDeactivateSettings) {
            return this.staticImageDeactivateSettings((StaticImageDeactivateScheduleActionSettings)((StaticImageDeactivateScheduleActionSettings.Builder)StaticImageDeactivateScheduleActionSettings.builder().applyMutation(staticImageDeactivateSettings)).build());
        }
    }
}

