/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDestinationVpc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDestinationVpc> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDestinationVpc.getter(InputDestinationVpc::availabilityZone)).setter(InputDestinationVpc.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDestinationVpc.getter(InputDestinationVpc::networkInterfaceId)).setter(InputDestinationVpc.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, NETWORK_INTERFACE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String networkInterfaceId;

    private InputDestinationVpc(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestinationVpc)) {
            return false;
        }
        InputDestinationVpc other = (InputDestinationVpc)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId());
    }

    public String toString() {
        return ToString.builder((String)"InputDestinationVpc").add("AvailabilityZone", (Object)this.availabilityZone()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDestinationVpc, T> g) {
        return obj -> g.apply((InputDestinationVpc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestinationVpc model) {
            this.availabilityZone(model.availabilityZone);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public InputDestinationVpc build() {
            return new InputDestinationVpc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDestinationVpc> {
        public Builder availabilityZone(String var1);

        public Builder networkInterfaceId(String var1);
    }
}

