/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;

public class ListInputSecurityGroupsPublisher
implements SdkPublisher<ListInputSecurityGroupsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListInputSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInputSecurityGroupsPublisher(MediaLiveAsyncClient client, ListInputSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInputSecurityGroupsPublisher(MediaLiveAsyncClient client, ListInputSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInputSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInputSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInputSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<ListInputSecurityGroupsResponse> {
        private ListInputSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInputSecurityGroupsResponse> nextPage(ListInputSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInputSecurityGroupsPublisher.this.client.listInputSecurityGroups(ListInputSecurityGroupsPublisher.this.firstRequest);
            }
            return ListInputSecurityGroupsPublisher.this.client.listInputSecurityGroups((ListInputSecurityGroupsRequest)((Object)ListInputSecurityGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

