/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultiplexAlertsRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, ListMultiplexAlertsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListMultiplexAlertsRequest.getter(ListMultiplexAlertsRequest::maxResults)).setter(ListMultiplexAlertsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiplexId").getter(ListMultiplexAlertsRequest.getter(ListMultiplexAlertsRequest::multiplexId)).setter(ListMultiplexAlertsRequest.setter(Builder::multiplexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMultiplexAlertsRequest.getter(ListMultiplexAlertsRequest::nextToken)).setter(ListMultiplexAlertsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> STATE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateFilter").getter(ListMultiplexAlertsRequest.getter(ListMultiplexAlertsRequest::stateFilter)).setter(ListMultiplexAlertsRequest.setter(Builder::stateFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("stateFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, MULTIPLEX_ID_FIELD, NEXT_TOKEN_FIELD, STATE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMultiplexAlertsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String multiplexId;
    private final String nextToken;
    private final String stateFilter;

    private ListMultiplexAlertsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.multiplexId = builder.multiplexId;
        this.nextToken = builder.nextToken;
        this.stateFilter = builder.stateFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String multiplexId() {
        return this.multiplexId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String stateFilter() {
        return this.stateFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexAlertsRequest)) {
            return false;
        }
        ListMultiplexAlertsRequest other = (ListMultiplexAlertsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.multiplexId(), other.multiplexId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.stateFilter(), other.stateFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListMultiplexAlertsRequest").add("MaxResults", (Object)this.maxResults()).add("MultiplexId", (Object)this.multiplexId()).add("NextToken", (Object)this.nextToken()).add("StateFilter", (Object)this.stateFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "MultiplexId": {
                return Optional.ofNullable(clazz.cast(this.multiplexId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StateFilter": {
                return Optional.ofNullable(clazz.cast(this.stateFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("multiplexId", MULTIPLEX_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("stateFilter", STATE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMultiplexAlertsRequest, T> g) {
        return obj -> g.apply((ListMultiplexAlertsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String multiplexId;
        private String nextToken;
        private String stateFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiplexAlertsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.multiplexId(model.multiplexId);
            this.nextToken(model.nextToken);
            this.stateFilter(model.stateFilter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMultiplexId() {
            return this.multiplexId;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStateFilter() {
            return this.stateFilter;
        }

        public final void setStateFilter(String stateFilter) {
            this.stateFilter = stateFilter;
        }

        @Override
        public final Builder stateFilter(String stateFilter) {
            this.stateFilter = stateFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMultiplexAlertsRequest build() {
            return new ListMultiplexAlertsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultiplexAlertsRequest> {
        public Builder maxResults(Integer var1);

        public Builder multiplexId(String var1);

        public Builder nextToken(String var1);

        public Builder stateFilter(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

