/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ArchiveContainerSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveOutputSettings> {
    private static final SdkField<ArchiveContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ArchiveOutputSettings.getter(ArchiveOutputSettings::containerSettings)).setter(ArchiveOutputSettings.setter(Builder::containerSettings)).constructor(ArchiveContainerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()}).build();
    private static final SdkField<String> EXTENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ArchiveOutputSettings.getter(ArchiveOutputSettings::extension)).setter(ArchiveOutputSettings.setter(Builder::extension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extension").build()}).build();
    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ArchiveOutputSettings.getter(ArchiveOutputSettings::nameModifier)).setter(ArchiveOutputSettings.setter(Builder::nameModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SETTINGS_FIELD, EXTENSION_FIELD, NAME_MODIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final ArchiveContainerSettings containerSettings;
    private final String extension;
    private final String nameModifier;

    private ArchiveOutputSettings(BuilderImpl builder) {
        this.containerSettings = builder.containerSettings;
        this.extension = builder.extension;
        this.nameModifier = builder.nameModifier;
    }

    public ArchiveContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public String extension() {
        return this.extension;
    }

    public String nameModifier() {
        return this.nameModifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.extension());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameModifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveOutputSettings)) {
            return false;
        }
        ArchiveOutputSettings other = (ArchiveOutputSettings)obj;
        return Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.extension(), other.extension()) && Objects.equals(this.nameModifier(), other.nameModifier());
    }

    public String toString() {
        return ToString.builder((String)"ArchiveOutputSettings").add("ContainerSettings", (Object)this.containerSettings()).add("Extension", (Object)this.extension()).add("NameModifier", (Object)this.nameModifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerSettings": {
                return Optional.ofNullable(clazz.cast(this.containerSettings()));
            }
            case "Extension": {
                return Optional.ofNullable(clazz.cast(this.extension()));
            }
            case "NameModifier": {
                return Optional.ofNullable(clazz.cast(this.nameModifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveOutputSettings, T> g) {
        return obj -> g.apply((ArchiveOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveContainerSettings containerSettings;
        private String extension;
        private String nameModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveOutputSettings model) {
            this.containerSettings(model.containerSettings);
            this.extension(model.extension);
            this.nameModifier(model.nameModifier);
        }

        public final ArchiveContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ArchiveContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ArchiveContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final String getExtension() {
            return this.extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getNameModifier() {
            return this.nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        public ArchiveOutputSettings build() {
            return new ArchiveOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveOutputSettings> {
        public Builder containerSettings(ArchiveContainerSettings var1);

        default public Builder containerSettings(Consumer<ArchiveContainerSettings.Builder> containerSettings) {
            return this.containerSettings((ArchiveContainerSettings)((ArchiveContainerSettings.Builder)ArchiveContainerSettings.builder().applyMutation(containerSettings)).build());
        }

        public Builder extension(String var1);

        public Builder nameModifier(String var1);
    }
}

