/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping;
import software.amazon.awssdk.services.medialive.model.CmafId3Behavior;
import software.amazon.awssdk.services.medialive.model.CmafIngestSegmentLengthUnits;
import software.amazon.awssdk.services.medialive.model.CmafKLVBehavior;
import software.amazon.awssdk.services.medialive.model.CmafNielsenId3Behavior;
import software.amazon.awssdk.services.medialive.model.CmafTimedMetadataId3Frame;
import software.amazon.awssdk.services.medialive.model.CmafTimedMetadataPassthrough;
import software.amazon.awssdk.services.medialive.model.Scte35Type;
import software.amazon.awssdk.services.medialive.model.___listOfCaptionLanguageMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPackageV2GroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPackageV2GroupSettings> {
    private static final SdkField<List<CaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionLanguageMappings").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::captionLanguageMappings)).setter(MediaPackageV2GroupSettings.setter(Builder::captionLanguageMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionLanguageMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID3_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id3Behavior").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::id3BehaviorAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::id3Behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id3Behavior").build()}).build();
    private static final SdkField<String> KLV_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KlvBehavior").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::klvBehaviorAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::klvBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klvBehavior").build()}).build();
    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NielsenId3Behavior").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::nielsenId3BehaviorAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::nielsenId3Behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build()}).build();
    private static final SdkField<String> SCTE35_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Type").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::scte35TypeAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::scte35Type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Type").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::segmentLength)).setter(MediaPackageV2GroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> SEGMENT_LENGTH_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentLengthUnits").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::segmentLengthUnitsAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::segmentLengthUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthUnits").build()}).build();
    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataId3Frame").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::timedMetadataId3FrameAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::timedMetadataId3Frame)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build()}).build();
    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimedMetadataId3Period").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::timedMetadataId3Period)).setter(MediaPackageV2GroupSettings.setter(Builder::timedMetadataId3Period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build()}).build();
    private static final SdkField<String> TIMED_METADATA_PASSTHROUGH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataPassthrough").getter(MediaPackageV2GroupSettings.getter(MediaPackageV2GroupSettings::timedMetadataPassthroughAsString)).setter(MediaPackageV2GroupSettings.setter(Builder::timedMetadataPassthrough)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataPassthrough").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_LANGUAGE_MAPPINGS_FIELD, ID3_BEHAVIOR_FIELD, KLV_BEHAVIOR_FIELD, NIELSEN_ID3_BEHAVIOR_FIELD, SCTE35_TYPE_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_UNITS_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD, TIMED_METADATA_PASSTHROUGH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaPackageV2GroupSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CaptionLanguageMapping> captionLanguageMappings;
    private final String id3Behavior;
    private final String klvBehavior;
    private final String nielsenId3Behavior;
    private final String scte35Type;
    private final Integer segmentLength;
    private final String segmentLengthUnits;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;
    private final String timedMetadataPassthrough;

    private MediaPackageV2GroupSettings(BuilderImpl builder) {
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.id3Behavior = builder.id3Behavior;
        this.klvBehavior = builder.klvBehavior;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.scte35Type = builder.scte35Type;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthUnits = builder.segmentLengthUnits;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timedMetadataPassthrough = builder.timedMetadataPassthrough;
    }

    public final boolean hasCaptionLanguageMappings() {
        return this.captionLanguageMappings != null && !(this.captionLanguageMappings instanceof SdkAutoConstructList);
    }

    public final List<CaptionLanguageMapping> captionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public final CmafId3Behavior id3Behavior() {
        return CmafId3Behavior.fromValue(this.id3Behavior);
    }

    public final String id3BehaviorAsString() {
        return this.id3Behavior;
    }

    public final CmafKLVBehavior klvBehavior() {
        return CmafKLVBehavior.fromValue(this.klvBehavior);
    }

    public final String klvBehaviorAsString() {
        return this.klvBehavior;
    }

    public final CmafNielsenId3Behavior nielsenId3Behavior() {
        return CmafNielsenId3Behavior.fromValue(this.nielsenId3Behavior);
    }

    public final String nielsenId3BehaviorAsString() {
        return this.nielsenId3Behavior;
    }

    public final Scte35Type scte35Type() {
        return Scte35Type.fromValue(this.scte35Type);
    }

    public final String scte35TypeAsString() {
        return this.scte35Type;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final CmafIngestSegmentLengthUnits segmentLengthUnits() {
        return CmafIngestSegmentLengthUnits.fromValue(this.segmentLengthUnits);
    }

    public final String segmentLengthUnitsAsString() {
        return this.segmentLengthUnits;
    }

    public final CmafTimedMetadataId3Frame timedMetadataId3Frame() {
        return CmafTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public final String timedMetadataId3FrameAsString() {
        return this.timedMetadataId3Frame;
    }

    public final Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public final CmafTimedMetadataPassthrough timedMetadataPassthrough() {
        return CmafTimedMetadataPassthrough.fromValue(this.timedMetadataPassthrough);
    }

    public final String timedMetadataPassthroughAsString() {
        return this.timedMetadataPassthrough;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionLanguageMappings() ? this.captionLanguageMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.klvBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35TypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLengthUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataPassthroughAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageV2GroupSettings)) {
            return false;
        }
        MediaPackageV2GroupSettings other = (MediaPackageV2GroupSettings)obj;
        return this.hasCaptionLanguageMappings() == other.hasCaptionLanguageMappings() && Objects.equals(this.captionLanguageMappings(), other.captionLanguageMappings()) && Objects.equals(this.id3BehaviorAsString(), other.id3BehaviorAsString()) && Objects.equals(this.klvBehaviorAsString(), other.klvBehaviorAsString()) && Objects.equals(this.nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString()) && Objects.equals(this.scte35TypeAsString(), other.scte35TypeAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentLengthUnitsAsString(), other.segmentLengthUnitsAsString()) && Objects.equals(this.timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period()) && Objects.equals(this.timedMetadataPassthroughAsString(), other.timedMetadataPassthroughAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MediaPackageV2GroupSettings").add("CaptionLanguageMappings", this.hasCaptionLanguageMappings() ? this.captionLanguageMappings() : null).add("Id3Behavior", (Object)this.id3BehaviorAsString()).add("KlvBehavior", (Object)this.klvBehaviorAsString()).add("NielsenId3Behavior", (Object)this.nielsenId3BehaviorAsString()).add("Scte35Type", (Object)this.scte35TypeAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentLengthUnits", (Object)this.segmentLengthUnitsAsString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameAsString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).add("TimedMetadataPassthrough", (Object)this.timedMetadataPassthroughAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptionLanguageMappings": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageMappings()));
            }
            case "Id3Behavior": {
                return Optional.ofNullable(clazz.cast(this.id3BehaviorAsString()));
            }
            case "KlvBehavior": {
                return Optional.ofNullable(clazz.cast(this.klvBehaviorAsString()));
            }
            case "NielsenId3Behavior": {
                return Optional.ofNullable(clazz.cast(this.nielsenId3BehaviorAsString()));
            }
            case "Scte35Type": {
                return Optional.ofNullable(clazz.cast(this.scte35TypeAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentLengthUnits": {
                return Optional.ofNullable(clazz.cast(this.segmentLengthUnitsAsString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3FrameAsString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3Period()));
            }
            case "TimedMetadataPassthrough": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataPassthroughAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("captionLanguageMappings", CAPTION_LANGUAGE_MAPPINGS_FIELD);
        map.put("id3Behavior", ID3_BEHAVIOR_FIELD);
        map.put("klvBehavior", KLV_BEHAVIOR_FIELD);
        map.put("nielsenId3Behavior", NIELSEN_ID3_BEHAVIOR_FIELD);
        map.put("scte35Type", SCTE35_TYPE_FIELD);
        map.put("segmentLength", SEGMENT_LENGTH_FIELD);
        map.put("segmentLengthUnits", SEGMENT_LENGTH_UNITS_FIELD);
        map.put("timedMetadataId3Frame", TIMED_METADATA_ID3_FRAME_FIELD);
        map.put("timedMetadataId3Period", TIMED_METADATA_ID3_PERIOD_FIELD);
        map.put("timedMetadataPassthrough", TIMED_METADATA_PASSTHROUGH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageV2GroupSettings, T> g) {
        return obj -> g.apply((MediaPackageV2GroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();
        private String id3Behavior;
        private String klvBehavior;
        private String nielsenId3Behavior;
        private String scte35Type;
        private Integer segmentLength;
        private String segmentLengthUnits;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;
        private String timedMetadataPassthrough;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageV2GroupSettings model) {
            this.captionLanguageMappings(model.captionLanguageMappings);
            this.id3Behavior(model.id3Behavior);
            this.klvBehavior(model.klvBehavior);
            this.nielsenId3Behavior(model.nielsenId3Behavior);
            this.scte35Type(model.scte35Type);
            this.segmentLength(model.segmentLength);
            this.segmentLengthUnits(model.segmentLengthUnits);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
            this.timedMetadataPassthrough(model.timedMetadataPassthrough);
        }

        public final List<CaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            List<CaptionLanguageMapping.Builder> result = ___listOfCaptionLanguageMappingCopier.copyToBuilder(this.captionLanguageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionLanguageMappings(Collection<CaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        @Override
        public final Builder captionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(CaptionLanguageMapping ... captionLanguageMappings) {
            this.captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<CaptionLanguageMapping.Builder> ... captionLanguageMappings) {
            this.captionLanguageMappings(Stream.of(captionLanguageMappings).map(c -> (CaptionLanguageMapping)((CaptionLanguageMapping.Builder)CaptionLanguageMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId3Behavior() {
            return this.id3Behavior;
        }

        public final void setId3Behavior(String id3Behavior) {
            this.id3Behavior = id3Behavior;
        }

        @Override
        public final Builder id3Behavior(String id3Behavior) {
            this.id3Behavior = id3Behavior;
            return this;
        }

        @Override
        public final Builder id3Behavior(CmafId3Behavior id3Behavior) {
            this.id3Behavior(id3Behavior == null ? null : id3Behavior.toString());
            return this;
        }

        public final String getKlvBehavior() {
            return this.klvBehavior;
        }

        public final void setKlvBehavior(String klvBehavior) {
            this.klvBehavior = klvBehavior;
        }

        @Override
        public final Builder klvBehavior(String klvBehavior) {
            this.klvBehavior = klvBehavior;
            return this;
        }

        @Override
        public final Builder klvBehavior(CmafKLVBehavior klvBehavior) {
            this.klvBehavior(klvBehavior == null ? null : klvBehavior.toString());
            return this;
        }

        public final String getNielsenId3Behavior() {
            return this.nielsenId3Behavior;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(CmafNielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final String getScte35Type() {
            return this.scte35Type;
        }

        public final void setScte35Type(String scte35Type) {
            this.scte35Type = scte35Type;
        }

        @Override
        public final Builder scte35Type(String scte35Type) {
            this.scte35Type = scte35Type;
            return this;
        }

        @Override
        public final Builder scte35Type(Scte35Type scte35Type) {
            this.scte35Type(scte35Type == null ? null : scte35Type.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthUnits() {
            return this.segmentLengthUnits;
        }

        public final void setSegmentLengthUnits(String segmentLengthUnits) {
            this.segmentLengthUnits = segmentLengthUnits;
        }

        @Override
        public final Builder segmentLengthUnits(String segmentLengthUnits) {
            this.segmentLengthUnits = segmentLengthUnits;
            return this;
        }

        @Override
        public final Builder segmentLengthUnits(CmafIngestSegmentLengthUnits segmentLengthUnits) {
            this.segmentLengthUnits(segmentLengthUnits == null ? null : segmentLengthUnits.toString());
            return this;
        }

        public final String getTimedMetadataId3Frame() {
            return this.timedMetadataId3Frame;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(CmafTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final String getTimedMetadataPassthrough() {
            return this.timedMetadataPassthrough;
        }

        public final void setTimedMetadataPassthrough(String timedMetadataPassthrough) {
            this.timedMetadataPassthrough = timedMetadataPassthrough;
        }

        @Override
        public final Builder timedMetadataPassthrough(String timedMetadataPassthrough) {
            this.timedMetadataPassthrough = timedMetadataPassthrough;
            return this;
        }

        @Override
        public final Builder timedMetadataPassthrough(CmafTimedMetadataPassthrough timedMetadataPassthrough) {
            this.timedMetadataPassthrough(timedMetadataPassthrough == null ? null : timedMetadataPassthrough.toString());
            return this;
        }

        public MediaPackageV2GroupSettings build() {
            return new MediaPackageV2GroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPackageV2GroupSettings> {
        public Builder captionLanguageMappings(Collection<CaptionLanguageMapping> var1);

        public Builder captionLanguageMappings(CaptionLanguageMapping ... var1);

        public Builder captionLanguageMappings(Consumer<CaptionLanguageMapping.Builder> ... var1);

        public Builder id3Behavior(String var1);

        public Builder id3Behavior(CmafId3Behavior var1);

        public Builder klvBehavior(String var1);

        public Builder klvBehavior(CmafKLVBehavior var1);

        public Builder nielsenId3Behavior(String var1);

        public Builder nielsenId3Behavior(CmafNielsenId3Behavior var1);

        public Builder scte35Type(String var1);

        public Builder scte35Type(Scte35Type var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentLengthUnits(String var1);

        public Builder segmentLengthUnits(CmafIngestSegmentLengthUnits var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(CmafTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);

        public Builder timedMetadataPassthrough(String var1);

        public Builder timedMetadataPassthrough(CmafTimedMetadataPassthrough var1);
    }
}

