/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.IpPoolCreateRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.RouteCreateRequest;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfIpPoolCreateRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfRouteCreateRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateNetworkRequest> {
    private static final SdkField<List<IpPoolCreateRequest>> IP_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPools").getter(CreateNetworkRequest.getter(CreateNetworkRequest::ipPools)).setter(CreateNetworkRequest.setter(Builder::ipPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPoolCreateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNetworkRequest.getter(CreateNetworkRequest::name)).setter(CreateNetworkRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateNetworkRequest.getter(CreateNetworkRequest::requestId)).setter(CreateNetworkRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<RouteCreateRequest>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(CreateNetworkRequest.getter(CreateNetworkRequest::routes)).setter(CreateNetworkRequest.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteCreateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateNetworkRequest.getter(CreateNetworkRequest::tags)).setter(CreateNetworkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_POOLS_FIELD, NAME_FIELD, REQUEST_ID_FIELD, ROUTES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNetworkRequest.memberNameToFieldInitializer();
    private final List<IpPoolCreateRequest> ipPools;
    private final String name;
    private final String requestId;
    private final List<RouteCreateRequest> routes;
    private final Map<String, String> tags;

    private CreateNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.ipPools = builder.ipPools;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.routes = builder.routes;
        this.tags = builder.tags;
    }

    public final boolean hasIpPools() {
        return this.ipPools != null && !(this.ipPools instanceof SdkAutoConstructList);
    }

    public final List<IpPoolCreateRequest> ipPools() {
        return this.ipPools;
    }

    public final String name() {
        return this.name;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<RouteCreateRequest> routes() {
        return this.routes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPools() ? this.ipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkRequest)) {
            return false;
        }
        CreateNetworkRequest other = (CreateNetworkRequest)((Object)obj);
        return this.hasIpPools() == other.hasIpPools() && Objects.equals(this.ipPools(), other.ipPools()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requestId(), other.requestId()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkRequest").add("IpPools", this.hasIpPools() ? this.ipPools() : null).add("Name", (Object)this.name()).add("RequestId", (Object)this.requestId()).add("Routes", this.hasRoutes() ? this.routes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpPools": {
                return Optional.ofNullable(clazz.cast(this.ipPools()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ipPools", IP_POOLS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("routes", ROUTES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkRequest, T> g) {
        return obj -> g.apply((CreateNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<IpPoolCreateRequest> ipPools = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String requestId;
        private List<RouteCreateRequest> routes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkRequest model) {
            super(model);
            this.ipPools(model.ipPools);
            this.name(model.name);
            this.requestId(model.requestId);
            this.routes(model.routes);
            this.tags(model.tags);
        }

        public final List<IpPoolCreateRequest.Builder> getIpPools() {
            List<IpPoolCreateRequest.Builder> result = ___listOfIpPoolCreateRequestCopier.copyToBuilder(this.ipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPools(Collection<IpPoolCreateRequest.BuilderImpl> ipPools) {
            this.ipPools = ___listOfIpPoolCreateRequestCopier.copyFromBuilder(ipPools);
        }

        @Override
        public final Builder ipPools(Collection<IpPoolCreateRequest> ipPools) {
            this.ipPools = ___listOfIpPoolCreateRequestCopier.copy(ipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(IpPoolCreateRequest ... ipPools) {
            this.ipPools(Arrays.asList(ipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(Consumer<IpPoolCreateRequest.Builder> ... ipPools) {
            this.ipPools(Stream.of(ipPools).map(c -> (IpPoolCreateRequest)((IpPoolCreateRequest.Builder)IpPoolCreateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final List<RouteCreateRequest.Builder> getRoutes() {
            List<RouteCreateRequest.Builder> result = ___listOfRouteCreateRequestCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<RouteCreateRequest.BuilderImpl> routes) {
            this.routes = ___listOfRouteCreateRequestCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<RouteCreateRequest> routes) {
            this.routes = ___listOfRouteCreateRequestCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteCreateRequest ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteCreateRequest.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (RouteCreateRequest)((RouteCreateRequest.Builder)RouteCreateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkRequest build() {
            return new CreateNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkRequest> {
        public Builder ipPools(Collection<IpPoolCreateRequest> var1);

        public Builder ipPools(IpPoolCreateRequest ... var1);

        public Builder ipPools(Consumer<IpPoolCreateRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder requestId(String var1);

        public Builder routes(Collection<RouteCreateRequest> var1);

        public Builder routes(RouteCreateRequest ... var1);

        public Builder routes(Consumer<RouteCreateRequest.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

