/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListSdiSourcesRequest;
import software.amazon.awssdk.services.medialive.model.ListSdiSourcesResponse;
import software.amazon.awssdk.services.medialive.model.SdiSourceSummary;

public class ListSdiSourcesPublisher
implements SdkPublisher<ListSdiSourcesResponse> {
    private final MediaLiveAsyncClient client;
    private final ListSdiSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSdiSourcesPublisher(MediaLiveAsyncClient client, ListSdiSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSdiSourcesPublisher(MediaLiveAsyncClient client, ListSdiSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSdiSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSdiSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SdiSourceSummary> sdiSources() {
        Function<ListSdiSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sdiSources() != null) {
                return response.sdiSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSdiSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSdiSourcesResponseFetcher
    implements AsyncPageFetcher<ListSdiSourcesResponse> {
        private ListSdiSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListSdiSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSdiSourcesResponse> nextPage(ListSdiSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListSdiSourcesPublisher.this.client.listSdiSources(ListSdiSourcesPublisher.this.firstRequest);
            }
            return ListSdiSourcesPublisher.this.client.listSdiSources((ListSdiSourcesRequest)((Object)ListSdiSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

