/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.FailedMediaResourceMapCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MediaResource;
import software.amazon.awssdk.services.medialive.model.MediaResourceMapCopier;
import software.amazon.awssdk.services.medialive.model.MonitorDeployment;
import software.amazon.awssdk.services.medialive.model.SignalMapStatus;
import software.amazon.awssdk.services.medialive.model.SuccessfulMonitorDeployment;
import software.amazon.awssdk.services.medialive.model.TagMapCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringMin7Max11PatternAws097Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMonitorDeploymentResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, StartMonitorDeploymentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::arn)).setter(StartMonitorDeploymentResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchAlarmTemplateGroupIds").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::cloudWatchAlarmTemplateGroupIds)).setter(StartMonitorDeploymentResponse.setter(Builder::cloudWatchAlarmTemplateGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplateGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::createdAt)).setter(StartMonitorDeploymentResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::description)).setter(StartMonitorDeploymentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISCOVERY_ENTRY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryEntryPointArn").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::discoveryEntryPointArn)).setter(StartMonitorDeploymentResponse.setter(Builder::discoveryEntryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryEntryPointArn").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::errorMessage)).setter(StartMonitorDeploymentResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<List<String>> EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventBridgeRuleTemplateGroupIds").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::eventBridgeRuleTemplateGroupIds)).setter(StartMonitorDeploymentResponse.setter(Builder::eventBridgeRuleTemplateGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeRuleTemplateGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, MediaResource>> FAILED_MEDIA_RESOURCE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FailedMediaResourceMap").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::failedMediaResourceMap)).setter(StartMonitorDeploymentResponse.setter(Builder::failedMediaResourceMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedMediaResourceMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::id)).setter(StartMonitorDeploymentResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_DISCOVERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastDiscoveredAt").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::lastDiscoveredAt)).setter(StartMonitorDeploymentResponse.setter(Builder::lastDiscoveredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDiscoveredAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<SuccessfulMonitorDeployment> LAST_SUCCESSFUL_MONITOR_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastSuccessfulMonitorDeployment").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::lastSuccessfulMonitorDeployment)).setter(StartMonitorDeploymentResponse.setter(Builder::lastSuccessfulMonitorDeployment)).constructor(SuccessfulMonitorDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulMonitorDeployment").build()}).build();
    private static final SdkField<Map<String, MediaResource>> MEDIA_RESOURCE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MediaResourceMap").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::mediaResourceMap)).setter(StartMonitorDeploymentResponse.setter(Builder::mediaResourceMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaResourceMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::modifiedAt)).setter(StartMonitorDeploymentResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> MONITOR_CHANGES_PENDING_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MonitorChangesPendingDeployment").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::monitorChangesPendingDeployment)).setter(StartMonitorDeploymentResponse.setter(Builder::monitorChangesPendingDeployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorChangesPendingDeployment").build()}).build();
    private static final SdkField<MonitorDeployment> MONITOR_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitorDeployment").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::monitorDeployment)).setter(StartMonitorDeploymentResponse.setter(Builder::monitorDeployment)).constructor(MonitorDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorDeployment").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::name)).setter(StartMonitorDeploymentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::statusAsString)).setter(StartMonitorDeploymentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartMonitorDeploymentResponse.getter(StartMonitorDeploymentResponse::tags)).setter(StartMonitorDeploymentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DISCOVERY_ENTRY_POINT_ARN_FIELD, ERROR_MESSAGE_FIELD, EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDS_FIELD, FAILED_MEDIA_RESOURCE_MAP_FIELD, ID_FIELD, LAST_DISCOVERED_AT_FIELD, LAST_SUCCESSFUL_MONITOR_DEPLOYMENT_FIELD, MEDIA_RESOURCE_MAP_FIELD, MODIFIED_AT_FIELD, MONITOR_CHANGES_PENDING_DEPLOYMENT_FIELD, MONITOR_DEPLOYMENT_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMonitorDeploymentResponse.memberNameToFieldInitializer();
    private final String arn;
    private final List<String> cloudWatchAlarmTemplateGroupIds;
    private final Instant createdAt;
    private final String description;
    private final String discoveryEntryPointArn;
    private final String errorMessage;
    private final List<String> eventBridgeRuleTemplateGroupIds;
    private final Map<String, MediaResource> failedMediaResourceMap;
    private final String id;
    private final Instant lastDiscoveredAt;
    private final SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment;
    private final Map<String, MediaResource> mediaResourceMap;
    private final Instant modifiedAt;
    private final Boolean monitorChangesPendingDeployment;
    private final MonitorDeployment monitorDeployment;
    private final String name;
    private final String status;
    private final Map<String, String> tags;

    private StartMonitorDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cloudWatchAlarmTemplateGroupIds = builder.cloudWatchAlarmTemplateGroupIds;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.discoveryEntryPointArn = builder.discoveryEntryPointArn;
        this.errorMessage = builder.errorMessage;
        this.eventBridgeRuleTemplateGroupIds = builder.eventBridgeRuleTemplateGroupIds;
        this.failedMediaResourceMap = builder.failedMediaResourceMap;
        this.id = builder.id;
        this.lastDiscoveredAt = builder.lastDiscoveredAt;
        this.lastSuccessfulMonitorDeployment = builder.lastSuccessfulMonitorDeployment;
        this.mediaResourceMap = builder.mediaResourceMap;
        this.modifiedAt = builder.modifiedAt;
        this.monitorChangesPendingDeployment = builder.monitorChangesPendingDeployment;
        this.monitorDeployment = builder.monitorDeployment;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasCloudWatchAlarmTemplateGroupIds() {
        return this.cloudWatchAlarmTemplateGroupIds != null && !(this.cloudWatchAlarmTemplateGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> cloudWatchAlarmTemplateGroupIds() {
        return this.cloudWatchAlarmTemplateGroupIds;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String discoveryEntryPointArn() {
        return this.discoveryEntryPointArn;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasEventBridgeRuleTemplateGroupIds() {
        return this.eventBridgeRuleTemplateGroupIds != null && !(this.eventBridgeRuleTemplateGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> eventBridgeRuleTemplateGroupIds() {
        return this.eventBridgeRuleTemplateGroupIds;
    }

    public final boolean hasFailedMediaResourceMap() {
        return this.failedMediaResourceMap != null && !(this.failedMediaResourceMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, MediaResource> failedMediaResourceMap() {
        return this.failedMediaResourceMap;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastDiscoveredAt() {
        return this.lastDiscoveredAt;
    }

    public final SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment() {
        return this.lastSuccessfulMonitorDeployment;
    }

    public final boolean hasMediaResourceMap() {
        return this.mediaResourceMap != null && !(this.mediaResourceMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, MediaResource> mediaResourceMap() {
        return this.mediaResourceMap;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final Boolean monitorChangesPendingDeployment() {
        return this.monitorChangesPendingDeployment;
    }

    public final MonitorDeployment monitorDeployment() {
        return this.monitorDeployment;
    }

    public final String name() {
        return this.name;
    }

    public final SignalMapStatus status() {
        return SignalMapStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchAlarmTemplateGroupIds() ? this.cloudWatchAlarmTemplateGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryEntryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventBridgeRuleTemplateGroupIds() ? this.eventBridgeRuleTemplateGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedMediaResourceMap() ? this.failedMediaResourceMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDiscoveredAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulMonitorDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaResourceMap() ? this.mediaResourceMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorChangesPendingDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMonitorDeploymentResponse)) {
            return false;
        }
        StartMonitorDeploymentResponse other = (StartMonitorDeploymentResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasCloudWatchAlarmTemplateGroupIds() == other.hasCloudWatchAlarmTemplateGroupIds() && Objects.equals(this.cloudWatchAlarmTemplateGroupIds(), other.cloudWatchAlarmTemplateGroupIds()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.discoveryEntryPointArn(), other.discoveryEntryPointArn()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasEventBridgeRuleTemplateGroupIds() == other.hasEventBridgeRuleTemplateGroupIds() && Objects.equals(this.eventBridgeRuleTemplateGroupIds(), other.eventBridgeRuleTemplateGroupIds()) && this.hasFailedMediaResourceMap() == other.hasFailedMediaResourceMap() && Objects.equals(this.failedMediaResourceMap(), other.failedMediaResourceMap()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastDiscoveredAt(), other.lastDiscoveredAt()) && Objects.equals(this.lastSuccessfulMonitorDeployment(), other.lastSuccessfulMonitorDeployment()) && this.hasMediaResourceMap() == other.hasMediaResourceMap() && Objects.equals(this.mediaResourceMap(), other.mediaResourceMap()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.monitorChangesPendingDeployment(), other.monitorChangesPendingDeployment()) && Objects.equals(this.monitorDeployment(), other.monitorDeployment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartMonitorDeploymentResponse").add("Arn", (Object)this.arn()).add("CloudWatchAlarmTemplateGroupIds", this.hasCloudWatchAlarmTemplateGroupIds() ? this.cloudWatchAlarmTemplateGroupIds() : null).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("DiscoveryEntryPointArn", (Object)this.discoveryEntryPointArn()).add("ErrorMessage", (Object)this.errorMessage()).add("EventBridgeRuleTemplateGroupIds", this.hasEventBridgeRuleTemplateGroupIds() ? this.eventBridgeRuleTemplateGroupIds() : null).add("FailedMediaResourceMap", this.hasFailedMediaResourceMap() ? this.failedMediaResourceMap() : null).add("Id", (Object)this.id()).add("LastDiscoveredAt", (Object)this.lastDiscoveredAt()).add("LastSuccessfulMonitorDeployment", (Object)this.lastSuccessfulMonitorDeployment()).add("MediaResourceMap", this.hasMediaResourceMap() ? this.mediaResourceMap() : null).add("ModifiedAt", (Object)this.modifiedAt()).add("MonitorChangesPendingDeployment", (Object)this.monitorChangesPendingDeployment()).add("MonitorDeployment", (Object)this.monitorDeployment()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CloudWatchAlarmTemplateGroupIds": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmTemplateGroupIds()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiscoveryEntryPointArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryEntryPointArn()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "EventBridgeRuleTemplateGroupIds": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeRuleTemplateGroupIds()));
            }
            case "FailedMediaResourceMap": {
                return Optional.ofNullable(clazz.cast(this.failedMediaResourceMap()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastDiscoveredAt": {
                return Optional.ofNullable(clazz.cast(this.lastDiscoveredAt()));
            }
            case "LastSuccessfulMonitorDeployment": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulMonitorDeployment()));
            }
            case "MediaResourceMap": {
                return Optional.ofNullable(clazz.cast(this.mediaResourceMap()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "MonitorChangesPendingDeployment": {
                return Optional.ofNullable(clazz.cast(this.monitorChangesPendingDeployment()));
            }
            case "MonitorDeployment": {
                return Optional.ofNullable(clazz.cast(this.monitorDeployment()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("cloudWatchAlarmTemplateGroupIds", CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("discoveryEntryPointArn", DISCOVERY_ENTRY_POINT_ARN_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("eventBridgeRuleTemplateGroupIds", EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDS_FIELD);
        map.put("failedMediaResourceMap", FAILED_MEDIA_RESOURCE_MAP_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastDiscoveredAt", LAST_DISCOVERED_AT_FIELD);
        map.put("lastSuccessfulMonitorDeployment", LAST_SUCCESSFUL_MONITOR_DEPLOYMENT_FIELD);
        map.put("mediaResourceMap", MEDIA_RESOURCE_MAP_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("monitorChangesPendingDeployment", MONITOR_CHANGES_PENDING_DEPLOYMENT_FIELD);
        map.put("monitorDeployment", MONITOR_DEPLOYMENT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMonitorDeploymentResponse, T> g) {
        return obj -> g.apply((StartMonitorDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> cloudWatchAlarmTemplateGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String description;
        private String discoveryEntryPointArn;
        private String errorMessage;
        private List<String> eventBridgeRuleTemplateGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, MediaResource> failedMediaResourceMap = DefaultSdkAutoConstructMap.getInstance();
        private String id;
        private Instant lastDiscoveredAt;
        private SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment;
        private Map<String, MediaResource> mediaResourceMap = DefaultSdkAutoConstructMap.getInstance();
        private Instant modifiedAt;
        private Boolean monitorChangesPendingDeployment;
        private MonitorDeployment monitorDeployment;
        private String name;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMonitorDeploymentResponse model) {
            super(model);
            this.arn(model.arn);
            this.cloudWatchAlarmTemplateGroupIds(model.cloudWatchAlarmTemplateGroupIds);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.discoveryEntryPointArn(model.discoveryEntryPointArn);
            this.errorMessage(model.errorMessage);
            this.eventBridgeRuleTemplateGroupIds(model.eventBridgeRuleTemplateGroupIds);
            this.failedMediaResourceMap(model.failedMediaResourceMap);
            this.id(model.id);
            this.lastDiscoveredAt(model.lastDiscoveredAt);
            this.lastSuccessfulMonitorDeployment(model.lastSuccessfulMonitorDeployment);
            this.mediaResourceMap(model.mediaResourceMap);
            this.modifiedAt(model.modifiedAt);
            this.monitorChangesPendingDeployment(model.monitorChangesPendingDeployment);
            this.monitorDeployment(model.monitorDeployment);
            this.name(model.name);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getCloudWatchAlarmTemplateGroupIds() {
            if (this.cloudWatchAlarmTemplateGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cloudWatchAlarmTemplateGroupIds;
        }

        public final void setCloudWatchAlarmTemplateGroupIds(Collection<String> cloudWatchAlarmTemplateGroupIds) {
            this.cloudWatchAlarmTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier.copy(cloudWatchAlarmTemplateGroupIds);
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroupIds(Collection<String> cloudWatchAlarmTemplateGroupIds) {
            this.cloudWatchAlarmTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier.copy(cloudWatchAlarmTemplateGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroupIds(String ... cloudWatchAlarmTemplateGroupIds) {
            this.cloudWatchAlarmTemplateGroupIds(Arrays.asList(cloudWatchAlarmTemplateGroupIds));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiscoveryEntryPointArn() {
            return this.discoveryEntryPointArn;
        }

        public final void setDiscoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
        }

        @Override
        public final Builder discoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getEventBridgeRuleTemplateGroupIds() {
            if (this.eventBridgeRuleTemplateGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventBridgeRuleTemplateGroupIds;
        }

        public final void setEventBridgeRuleTemplateGroupIds(Collection<String> eventBridgeRuleTemplateGroupIds) {
            this.eventBridgeRuleTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier.copy(eventBridgeRuleTemplateGroupIds);
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroupIds(Collection<String> eventBridgeRuleTemplateGroupIds) {
            this.eventBridgeRuleTemplateGroupIds = ___listOf__stringMin7Max11PatternAws097Copier.copy(eventBridgeRuleTemplateGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroupIds(String ... eventBridgeRuleTemplateGroupIds) {
            this.eventBridgeRuleTemplateGroupIds(Arrays.asList(eventBridgeRuleTemplateGroupIds));
            return this;
        }

        public final Map<String, MediaResource.Builder> getFailedMediaResourceMap() {
            Map<String, MediaResource.Builder> result = FailedMediaResourceMapCopier.copyToBuilder(this.failedMediaResourceMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedMediaResourceMap(Map<String, MediaResource.BuilderImpl> failedMediaResourceMap) {
            this.failedMediaResourceMap = FailedMediaResourceMapCopier.copyFromBuilder(failedMediaResourceMap);
        }

        @Override
        public final Builder failedMediaResourceMap(Map<String, MediaResource> failedMediaResourceMap) {
            this.failedMediaResourceMap = FailedMediaResourceMapCopier.copy(failedMediaResourceMap);
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastDiscoveredAt() {
            return this.lastDiscoveredAt;
        }

        public final void setLastDiscoveredAt(Instant lastDiscoveredAt) {
            this.lastDiscoveredAt = lastDiscoveredAt;
        }

        @Override
        public final Builder lastDiscoveredAt(Instant lastDiscoveredAt) {
            this.lastDiscoveredAt = lastDiscoveredAt;
            return this;
        }

        public final SuccessfulMonitorDeployment.Builder getLastSuccessfulMonitorDeployment() {
            return this.lastSuccessfulMonitorDeployment != null ? this.lastSuccessfulMonitorDeployment.toBuilder() : null;
        }

        public final void setLastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment.BuilderImpl lastSuccessfulMonitorDeployment) {
            this.lastSuccessfulMonitorDeployment = lastSuccessfulMonitorDeployment != null ? lastSuccessfulMonitorDeployment.build() : null;
        }

        @Override
        public final Builder lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment lastSuccessfulMonitorDeployment) {
            this.lastSuccessfulMonitorDeployment = lastSuccessfulMonitorDeployment;
            return this;
        }

        public final Map<String, MediaResource.Builder> getMediaResourceMap() {
            Map<String, MediaResource.Builder> result = MediaResourceMapCopier.copyToBuilder(this.mediaResourceMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMediaResourceMap(Map<String, MediaResource.BuilderImpl> mediaResourceMap) {
            this.mediaResourceMap = MediaResourceMapCopier.copyFromBuilder(mediaResourceMap);
        }

        @Override
        public final Builder mediaResourceMap(Map<String, MediaResource> mediaResourceMap) {
            this.mediaResourceMap = MediaResourceMapCopier.copy(mediaResourceMap);
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Boolean getMonitorChangesPendingDeployment() {
            return this.monitorChangesPendingDeployment;
        }

        public final void setMonitorChangesPendingDeployment(Boolean monitorChangesPendingDeployment) {
            this.monitorChangesPendingDeployment = monitorChangesPendingDeployment;
        }

        @Override
        public final Builder monitorChangesPendingDeployment(Boolean monitorChangesPendingDeployment) {
            this.monitorChangesPendingDeployment = monitorChangesPendingDeployment;
            return this;
        }

        public final MonitorDeployment.Builder getMonitorDeployment() {
            return this.monitorDeployment != null ? this.monitorDeployment.toBuilder() : null;
        }

        public final void setMonitorDeployment(MonitorDeployment.BuilderImpl monitorDeployment) {
            this.monitorDeployment = monitorDeployment != null ? monitorDeployment.build() : null;
        }

        @Override
        public final Builder monitorDeployment(MonitorDeployment monitorDeployment) {
            this.monitorDeployment = monitorDeployment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SignalMapStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public StartMonitorDeploymentResponse build() {
            return new StartMonitorDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMonitorDeploymentResponse> {
        public Builder arn(String var1);

        public Builder cloudWatchAlarmTemplateGroupIds(Collection<String> var1);

        public Builder cloudWatchAlarmTemplateGroupIds(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder discoveryEntryPointArn(String var1);

        public Builder errorMessage(String var1);

        public Builder eventBridgeRuleTemplateGroupIds(Collection<String> var1);

        public Builder eventBridgeRuleTemplateGroupIds(String ... var1);

        public Builder failedMediaResourceMap(Map<String, MediaResource> var1);

        public Builder id(String var1);

        public Builder lastDiscoveredAt(Instant var1);

        public Builder lastSuccessfulMonitorDeployment(SuccessfulMonitorDeployment var1);

        default public Builder lastSuccessfulMonitorDeployment(Consumer<SuccessfulMonitorDeployment.Builder> lastSuccessfulMonitorDeployment) {
            return this.lastSuccessfulMonitorDeployment((SuccessfulMonitorDeployment)((SuccessfulMonitorDeployment.Builder)SuccessfulMonitorDeployment.builder().applyMutation(lastSuccessfulMonitorDeployment)).build());
        }

        public Builder mediaResourceMap(Map<String, MediaResource> var1);

        public Builder modifiedAt(Instant var1);

        public Builder monitorChangesPendingDeployment(Boolean var1);

        public Builder monitorDeployment(MonitorDeployment var1);

        default public Builder monitorDeployment(Consumer<MonitorDeployment.Builder> monitorDeployment) {
            return this.monitorDeployment((MonitorDeployment)((MonitorDeployment.Builder)MonitorDeployment.builder().applyMutation(monitorDeployment)).build());
        }

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(SignalMapStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

