/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputDeviceOutputType {
    NONE("NONE"),
    MEDIALIVE_INPUT("MEDIALIVE_INPUT"),
    MEDIACONNECT_FLOW("MEDIACONNECT_FLOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputDeviceOutputType> VALUE_MAP;
    private final String value;

    private InputDeviceOutputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputDeviceOutputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputDeviceOutputType> knownValues() {
        EnumSet<InputDeviceOutputType> knownValues = EnumSet.allOf(InputDeviceOutputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputDeviceOutputType.class, InputDeviceOutputType::toString);
    }
}

