/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateGroupSummary;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfCloudWatchAlarmTemplateGroupSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCloudWatchAlarmTemplateGroupsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListCloudWatchAlarmTemplateGroupsResponse> {
    private static final SdkField<List<CloudWatchAlarmTemplateGroupSummary>> CLOUD_WATCH_ALARM_TEMPLATE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchAlarmTemplateGroups").getter(ListCloudWatchAlarmTemplateGroupsResponse.getter(ListCloudWatchAlarmTemplateGroupsResponse::cloudWatchAlarmTemplateGroups)).setter(ListCloudWatchAlarmTemplateGroupsResponse.setter(Builder::cloudWatchAlarmTemplateGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplateGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchAlarmTemplateGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCloudWatchAlarmTemplateGroupsResponse.getter(ListCloudWatchAlarmTemplateGroupsResponse::nextToken)).setter(ListCloudWatchAlarmTemplateGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_ALARM_TEMPLATE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCloudWatchAlarmTemplateGroupsResponse.memberNameToFieldInitializer();
    private final List<CloudWatchAlarmTemplateGroupSummary> cloudWatchAlarmTemplateGroups;
    private final String nextToken;

    private ListCloudWatchAlarmTemplateGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplateGroups = builder.cloudWatchAlarmTemplateGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCloudWatchAlarmTemplateGroups() {
        return this.cloudWatchAlarmTemplateGroups != null && !(this.cloudWatchAlarmTemplateGroups instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchAlarmTemplateGroupSummary> cloudWatchAlarmTemplateGroups() {
        return this.cloudWatchAlarmTemplateGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchAlarmTemplateGroups() ? this.cloudWatchAlarmTemplateGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudWatchAlarmTemplateGroupsResponse)) {
            return false;
        }
        ListCloudWatchAlarmTemplateGroupsResponse other = (ListCloudWatchAlarmTemplateGroupsResponse)((Object)obj);
        return this.hasCloudWatchAlarmTemplateGroups() == other.hasCloudWatchAlarmTemplateGroups() && Objects.equals(this.cloudWatchAlarmTemplateGroups(), other.cloudWatchAlarmTemplateGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCloudWatchAlarmTemplateGroupsResponse").add("CloudWatchAlarmTemplateGroups", this.hasCloudWatchAlarmTemplateGroups() ? this.cloudWatchAlarmTemplateGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchAlarmTemplateGroups": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmTemplateGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchAlarmTemplateGroups", CLOUD_WATCH_ALARM_TEMPLATE_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudWatchAlarmTemplateGroupsResponse, T> g) {
        return obj -> g.apply((ListCloudWatchAlarmTemplateGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<CloudWatchAlarmTemplateGroupSummary> cloudWatchAlarmTemplateGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudWatchAlarmTemplateGroupsResponse model) {
            super(model);
            this.cloudWatchAlarmTemplateGroups(model.cloudWatchAlarmTemplateGroups);
            this.nextToken(model.nextToken);
        }

        public final List<CloudWatchAlarmTemplateGroupSummary.Builder> getCloudWatchAlarmTemplateGroups() {
            List<CloudWatchAlarmTemplateGroupSummary.Builder> result = ___listOfCloudWatchAlarmTemplateGroupSummaryCopier.copyToBuilder(this.cloudWatchAlarmTemplateGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchAlarmTemplateGroups(Collection<CloudWatchAlarmTemplateGroupSummary.BuilderImpl> cloudWatchAlarmTemplateGroups) {
            this.cloudWatchAlarmTemplateGroups = ___listOfCloudWatchAlarmTemplateGroupSummaryCopier.copyFromBuilder(cloudWatchAlarmTemplateGroups);
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroups(Collection<CloudWatchAlarmTemplateGroupSummary> cloudWatchAlarmTemplateGroups) {
            this.cloudWatchAlarmTemplateGroups = ___listOfCloudWatchAlarmTemplateGroupSummaryCopier.copy(cloudWatchAlarmTemplateGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroups(CloudWatchAlarmTemplateGroupSummary ... cloudWatchAlarmTemplateGroups) {
            this.cloudWatchAlarmTemplateGroups(Arrays.asList(cloudWatchAlarmTemplateGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroups(Consumer<CloudWatchAlarmTemplateGroupSummary.Builder> ... cloudWatchAlarmTemplateGroups) {
            this.cloudWatchAlarmTemplateGroups(Stream.of(cloudWatchAlarmTemplateGroups).map(c -> (CloudWatchAlarmTemplateGroupSummary)((CloudWatchAlarmTemplateGroupSummary.Builder)CloudWatchAlarmTemplateGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCloudWatchAlarmTemplateGroupsResponse build() {
            return new ListCloudWatchAlarmTemplateGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCloudWatchAlarmTemplateGroupsResponse> {
        public Builder cloudWatchAlarmTemplateGroups(Collection<CloudWatchAlarmTemplateGroupSummary> var1);

        public Builder cloudWatchAlarmTemplateGroups(CloudWatchAlarmTemplateGroupSummary ... var1);

        public Builder cloudWatchAlarmTemplateGroups(Consumer<CloudWatchAlarmTemplateGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

