/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSdpLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSdpLocation> {
    private static final SdkField<Integer> MEDIA_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaIndex").getter(InputSdpLocation.getter(InputSdpLocation::mediaIndex)).setter(InputSdpLocation.setter(Builder::mediaIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaIndex").build()}).build();
    private static final SdkField<String> SDP_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SdpUrl").getter(InputSdpLocation.getter(InputSdpLocation::sdpUrl)).setter(InputSdpLocation.setter(Builder::sdpUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdpUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_INDEX_FIELD, SDP_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputSdpLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer mediaIndex;
    private final String sdpUrl;

    private InputSdpLocation(BuilderImpl builder) {
        this.mediaIndex = builder.mediaIndex;
        this.sdpUrl = builder.sdpUrl;
    }

    public final Integer mediaIndex() {
        return this.mediaIndex;
    }

    public final String sdpUrl() {
        return this.sdpUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdpUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSdpLocation)) {
            return false;
        }
        InputSdpLocation other = (InputSdpLocation)obj;
        return Objects.equals(this.mediaIndex(), other.mediaIndex()) && Objects.equals(this.sdpUrl(), other.sdpUrl());
    }

    public final String toString() {
        return ToString.builder((String)"InputSdpLocation").add("MediaIndex", (Object)this.mediaIndex()).add("SdpUrl", (Object)this.sdpUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaIndex": {
                return Optional.ofNullable(clazz.cast(this.mediaIndex()));
            }
            case "SdpUrl": {
                return Optional.ofNullable(clazz.cast(this.sdpUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mediaIndex", MEDIA_INDEX_FIELD);
        map.put("sdpUrl", SDP_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSdpLocation, T> g) {
        return obj -> g.apply((InputSdpLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer mediaIndex;
        private String sdpUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSdpLocation model) {
            this.mediaIndex(model.mediaIndex);
            this.sdpUrl(model.sdpUrl);
        }

        public final Integer getMediaIndex() {
            return this.mediaIndex;
        }

        public final void setMediaIndex(Integer mediaIndex) {
            this.mediaIndex = mediaIndex;
        }

        @Override
        public final Builder mediaIndex(Integer mediaIndex) {
            this.mediaIndex = mediaIndex;
            return this;
        }

        public final String getSdpUrl() {
            return this.sdpUrl;
        }

        public final void setSdpUrl(String sdpUrl) {
            this.sdpUrl = sdpUrl;
        }

        @Override
        public final Builder sdpUrl(String sdpUrl) {
            this.sdpUrl = sdpUrl;
            return this;
        }

        public InputSdpLocation build() {
            return new InputSdpLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSdpLocation> {
        public Builder mediaIndex(Integer var1);

        public Builder sdpUrl(String var1);
    }
}

