/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.WavCodingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WavSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WavSettings> {
    private static final SdkField<Double> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BitDepth").getter(WavSettings.getter(WavSettings::bitDepth)).setter(WavSettings.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(WavSettings.getter(WavSettings::codingModeAsString)).setter(WavSettings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<Double> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleRate").getter(WavSettings.getter(WavSettings::sampleRate)).setter(WavSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD, CODING_MODE_FIELD, SAMPLE_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WavSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double bitDepth;
    private final String codingMode;
    private final Double sampleRate;

    private WavSettings(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.codingMode = builder.codingMode;
        this.sampleRate = builder.sampleRate;
    }

    public final Double bitDepth() {
        return this.bitDepth;
    }

    public final WavCodingMode codingMode() {
        return WavCodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Double sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WavSettings)) {
            return false;
        }
        WavSettings other = (WavSettings)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"WavSettings").add("BitDepth", (Object)this.bitDepth()).add("CodingMode", (Object)this.codingModeAsString()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bitDepth", BIT_DEPTH_FIELD);
        map.put("codingMode", CODING_MODE_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WavSettings, T> g) {
        return obj -> g.apply((WavSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitDepth;
        private String codingMode;
        private Double sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(WavSettings model) {
            this.bitDepth(model.bitDepth);
            this.codingMode(model.codingMode);
            this.sampleRate(model.sampleRate);
        }

        public final Double getBitDepth() {
            return this.bitDepth;
        }

        public final void setBitDepth(Double bitDepth) {
            this.bitDepth = bitDepth;
        }

        @Override
        public final Builder bitDepth(Double bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(WavCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final Double getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public WavSettings build() {
            return new WavSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WavSettings> {
        public Builder bitDepth(Double var1);

        public Builder codingMode(String var1);

        public Builder codingMode(WavCodingMode var1);

        public Builder sampleRate(Double var1);
    }
}

