/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.DvbSdtOutputSdt;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DvbSdtSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DvbSdtSettings> {
    private static final SdkField<String> OUTPUT_SDT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputSdt").getter(DvbSdtSettings.getter(DvbSdtSettings::outputSdtAsString)).setter(DvbSdtSettings.setter(Builder::outputSdt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSdt").build()}).build();
    private static final SdkField<Integer> REP_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RepInterval").getter(DvbSdtSettings.getter(DvbSdtSettings::repInterval)).setter(DvbSdtSettings.setter(Builder::repInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repInterval").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(DvbSdtSettings.getter(DvbSdtSettings::serviceName)).setter(DvbSdtSettings.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceProviderName").getter(DvbSdtSettings.getter(DvbSdtSettings::serviceProviderName)).setter(DvbSdtSettings.setter(Builder::serviceProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceProviderName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SDT_FIELD, REP_INTERVAL_FIELD, SERVICE_NAME_FIELD, SERVICE_PROVIDER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DvbSdtSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputSdt;
    private final Integer repInterval;
    private final String serviceName;
    private final String serviceProviderName;

    private DvbSdtSettings(BuilderImpl builder) {
        this.outputSdt = builder.outputSdt;
        this.repInterval = builder.repInterval;
        this.serviceName = builder.serviceName;
        this.serviceProviderName = builder.serviceProviderName;
    }

    public final DvbSdtOutputSdt outputSdt() {
        return DvbSdtOutputSdt.fromValue(this.outputSdt);
    }

    public final String outputSdtAsString() {
        return this.outputSdt;
    }

    public final Integer repInterval() {
        return this.repInterval;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceProviderName() {
        return this.serviceProviderName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSdtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProviderName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSdtSettings)) {
            return false;
        }
        DvbSdtSettings other = (DvbSdtSettings)obj;
        return Objects.equals(this.outputSdtAsString(), other.outputSdtAsString()) && Objects.equals(this.repInterval(), other.repInterval()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceProviderName(), other.serviceProviderName());
    }

    public final String toString() {
        return ToString.builder((String)"DvbSdtSettings").add("OutputSdt", (Object)this.outputSdtAsString()).add("RepInterval", (Object)this.repInterval()).add("ServiceName", (Object)this.serviceName()).add("ServiceProviderName", (Object)this.serviceProviderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputSdt": {
                return Optional.ofNullable(clazz.cast(this.outputSdtAsString()));
            }
            case "RepInterval": {
                return Optional.ofNullable(clazz.cast(this.repInterval()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceProviderName": {
                return Optional.ofNullable(clazz.cast(this.serviceProviderName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("outputSdt", OUTPUT_SDT_FIELD);
        map.put("repInterval", REP_INTERVAL_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceProviderName", SERVICE_PROVIDER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DvbSdtSettings, T> g) {
        return obj -> g.apply((DvbSdtSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputSdt;
        private Integer repInterval;
        private String serviceName;
        private String serviceProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSdtSettings model) {
            this.outputSdt(model.outputSdt);
            this.repInterval(model.repInterval);
            this.serviceName(model.serviceName);
            this.serviceProviderName(model.serviceProviderName);
        }

        public final String getOutputSdt() {
            return this.outputSdt;
        }

        public final void setOutputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
        }

        @Override
        public final Builder outputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
            return this;
        }

        @Override
        public final Builder outputSdt(DvbSdtOutputSdt outputSdt) {
            this.outputSdt(outputSdt == null ? null : outputSdt.toString());
            return this;
        }

        public final Integer getRepInterval() {
            return this.repInterval;
        }

        public final void setRepInterval(Integer repInterval) {
            this.repInterval = repInterval;
        }

        @Override
        public final Builder repInterval(Integer repInterval) {
            this.repInterval = repInterval;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceProviderName() {
            return this.serviceProviderName;
        }

        public final void setServiceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
        }

        @Override
        public final Builder serviceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
            return this;
        }

        public DvbSdtSettings build() {
            return new DvbSdtSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DvbSdtSettings> {
        public Builder outputSdt(String var1);

        public Builder outputSdt(DvbSdtOutputSdt var1);

        public Builder repInterval(Integer var1);

        public Builder serviceName(String var1);

        public Builder serviceProviderName(String var1);
    }
}

