/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SdiSourceState {
    IDLE("IDLE"),
    IN_USE("IN_USE"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SdiSourceState> VALUE_MAP;
    private final String value;

    private SdiSourceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SdiSourceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SdiSourceState> knownValues() {
        EnumSet<SdiSourceState> knownValues = EnumSet.allOf(SdiSourceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SdiSourceState.class, SdiSourceState::toString);
    }
}

