/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeState {
    CREATED("CREATED"),
    REGISTERING("REGISTERING"),
    READY_TO_ACTIVATE("READY_TO_ACTIVATE"),
    REGISTRATION_FAILED("REGISTRATION_FAILED"),
    ACTIVATION_FAILED("ACTIVATION_FAILED"),
    ACTIVE("ACTIVE"),
    READY("READY"),
    IN_USE("IN_USE"),
    DEREGISTERING("DEREGISTERING"),
    DRAINING("DRAINING"),
    DEREGISTRATION_FAILED("DEREGISTRATION_FAILED"),
    DEREGISTERED("DEREGISTERED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeState> VALUE_MAP;
    private final String value;

    private NodeState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeState> knownValues() {
        EnumSet<NodeState> knownValues = EnumSet.allOf(NodeState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeState.class, NodeState::toString);
    }
}

