/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;

public class ListCloudWatchAlarmTemplatesPublisher
implements SdkPublisher<ListCloudWatchAlarmTemplatesResponse> {
    private final MediaLiveAsyncClient client;
    private final ListCloudWatchAlarmTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCloudWatchAlarmTemplatesPublisher(MediaLiveAsyncClient client, ListCloudWatchAlarmTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCloudWatchAlarmTemplatesPublisher(MediaLiveAsyncClient client, ListCloudWatchAlarmTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCloudWatchAlarmTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCloudWatchAlarmTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates() {
        Function<ListCloudWatchAlarmTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudWatchAlarmTemplates() != null) {
                return response.cloudWatchAlarmTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCloudWatchAlarmTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCloudWatchAlarmTemplatesResponseFetcher
    implements AsyncPageFetcher<ListCloudWatchAlarmTemplatesResponse> {
        private ListCloudWatchAlarmTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudWatchAlarmTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCloudWatchAlarmTemplatesResponse> nextPage(ListCloudWatchAlarmTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCloudWatchAlarmTemplatesPublisher.this.client.listCloudWatchAlarmTemplates(ListCloudWatchAlarmTemplatesPublisher.this.firstRequest);
            }
            return ListCloudWatchAlarmTemplatesPublisher.this.client.listCloudWatchAlarmTemplates((ListCloudWatchAlarmTemplatesRequest)((Object)ListCloudWatchAlarmTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

