/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.model.InputLossImageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputLossBehavior
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputLossBehavior> {
    private static final SdkField<Integer> BLACK_FRAME_MSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlackFrameMsec").getter(InputLossBehavior.getter(InputLossBehavior::blackFrameMsec)).setter(InputLossBehavior.setter(Builder::blackFrameMsec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackFrameMsec").build()}).build();
    private static final SdkField<String> INPUT_LOSS_IMAGE_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputLossImageColor").getter(InputLossBehavior.getter(InputLossBehavior::inputLossImageColor)).setter(InputLossBehavior.setter(Builder::inputLossImageColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossImageColor").build()}).build();
    private static final SdkField<InputLocation> INPUT_LOSS_IMAGE_SLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputLossImageSlate").getter(InputLossBehavior.getter(InputLossBehavior::inputLossImageSlate)).setter(InputLossBehavior.setter(Builder::inputLossImageSlate)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossImageSlate").build()}).build();
    private static final SdkField<String> INPUT_LOSS_IMAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputLossImageType").getter(InputLossBehavior.getter(InputLossBehavior::inputLossImageTypeAsString)).setter(InputLossBehavior.setter(Builder::inputLossImageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossImageType").build()}).build();
    private static final SdkField<Integer> REPEAT_FRAME_MSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RepeatFrameMsec").getter(InputLossBehavior.getter(InputLossBehavior::repeatFrameMsec)).setter(InputLossBehavior.setter(Builder::repeatFrameMsec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatFrameMsec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACK_FRAME_MSEC_FIELD, INPUT_LOSS_IMAGE_COLOR_FIELD, INPUT_LOSS_IMAGE_SLATE_FIELD, INPUT_LOSS_IMAGE_TYPE_FIELD, REPEAT_FRAME_MSEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputLossBehavior.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer blackFrameMsec;
    private final String inputLossImageColor;
    private final InputLocation inputLossImageSlate;
    private final String inputLossImageType;
    private final Integer repeatFrameMsec;

    private InputLossBehavior(BuilderImpl builder) {
        this.blackFrameMsec = builder.blackFrameMsec;
        this.inputLossImageColor = builder.inputLossImageColor;
        this.inputLossImageSlate = builder.inputLossImageSlate;
        this.inputLossImageType = builder.inputLossImageType;
        this.repeatFrameMsec = builder.repeatFrameMsec;
    }

    public final Integer blackFrameMsec() {
        return this.blackFrameMsec;
    }

    public final String inputLossImageColor() {
        return this.inputLossImageColor;
    }

    public final InputLocation inputLossImageSlate() {
        return this.inputLossImageSlate;
    }

    public final InputLossImageType inputLossImageType() {
        return InputLossImageType.fromValue(this.inputLossImageType);
    }

    public final String inputLossImageTypeAsString() {
        return this.inputLossImageType;
    }

    public final Integer repeatFrameMsec() {
        return this.repeatFrameMsec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blackFrameMsec());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossImageColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossImageSlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossImageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatFrameMsec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLossBehavior)) {
            return false;
        }
        InputLossBehavior other = (InputLossBehavior)obj;
        return Objects.equals(this.blackFrameMsec(), other.blackFrameMsec()) && Objects.equals(this.inputLossImageColor(), other.inputLossImageColor()) && Objects.equals(this.inputLossImageSlate(), other.inputLossImageSlate()) && Objects.equals(this.inputLossImageTypeAsString(), other.inputLossImageTypeAsString()) && Objects.equals(this.repeatFrameMsec(), other.repeatFrameMsec());
    }

    public final String toString() {
        return ToString.builder((String)"InputLossBehavior").add("BlackFrameMsec", (Object)this.blackFrameMsec()).add("InputLossImageColor", (Object)this.inputLossImageColor()).add("InputLossImageSlate", (Object)this.inputLossImageSlate()).add("InputLossImageType", (Object)this.inputLossImageTypeAsString()).add("RepeatFrameMsec", (Object)this.repeatFrameMsec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlackFrameMsec": {
                return Optional.ofNullable(clazz.cast(this.blackFrameMsec()));
            }
            case "InputLossImageColor": {
                return Optional.ofNullable(clazz.cast(this.inputLossImageColor()));
            }
            case "InputLossImageSlate": {
                return Optional.ofNullable(clazz.cast(this.inputLossImageSlate()));
            }
            case "InputLossImageType": {
                return Optional.ofNullable(clazz.cast(this.inputLossImageTypeAsString()));
            }
            case "RepeatFrameMsec": {
                return Optional.ofNullable(clazz.cast(this.repeatFrameMsec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blackFrameMsec", BLACK_FRAME_MSEC_FIELD);
        map.put("inputLossImageColor", INPUT_LOSS_IMAGE_COLOR_FIELD);
        map.put("inputLossImageSlate", INPUT_LOSS_IMAGE_SLATE_FIELD);
        map.put("inputLossImageType", INPUT_LOSS_IMAGE_TYPE_FIELD);
        map.put("repeatFrameMsec", REPEAT_FRAME_MSEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputLossBehavior, T> g) {
        return obj -> g.apply((InputLossBehavior)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer blackFrameMsec;
        private String inputLossImageColor;
        private InputLocation inputLossImageSlate;
        private String inputLossImageType;
        private Integer repeatFrameMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLossBehavior model) {
            this.blackFrameMsec(model.blackFrameMsec);
            this.inputLossImageColor(model.inputLossImageColor);
            this.inputLossImageSlate(model.inputLossImageSlate);
            this.inputLossImageType(model.inputLossImageType);
            this.repeatFrameMsec(model.repeatFrameMsec);
        }

        public final Integer getBlackFrameMsec() {
            return this.blackFrameMsec;
        }

        public final void setBlackFrameMsec(Integer blackFrameMsec) {
            this.blackFrameMsec = blackFrameMsec;
        }

        @Override
        public final Builder blackFrameMsec(Integer blackFrameMsec) {
            this.blackFrameMsec = blackFrameMsec;
            return this;
        }

        public final String getInputLossImageColor() {
            return this.inputLossImageColor;
        }

        public final void setInputLossImageColor(String inputLossImageColor) {
            this.inputLossImageColor = inputLossImageColor;
        }

        @Override
        public final Builder inputLossImageColor(String inputLossImageColor) {
            this.inputLossImageColor = inputLossImageColor;
            return this;
        }

        public final InputLocation.Builder getInputLossImageSlate() {
            return this.inputLossImageSlate != null ? this.inputLossImageSlate.toBuilder() : null;
        }

        public final void setInputLossImageSlate(InputLocation.BuilderImpl inputLossImageSlate) {
            this.inputLossImageSlate = inputLossImageSlate != null ? inputLossImageSlate.build() : null;
        }

        @Override
        public final Builder inputLossImageSlate(InputLocation inputLossImageSlate) {
            this.inputLossImageSlate = inputLossImageSlate;
            return this;
        }

        public final String getInputLossImageType() {
            return this.inputLossImageType;
        }

        public final void setInputLossImageType(String inputLossImageType) {
            this.inputLossImageType = inputLossImageType;
        }

        @Override
        public final Builder inputLossImageType(String inputLossImageType) {
            this.inputLossImageType = inputLossImageType;
            return this;
        }

        @Override
        public final Builder inputLossImageType(InputLossImageType inputLossImageType) {
            this.inputLossImageType(inputLossImageType == null ? null : inputLossImageType.toString());
            return this;
        }

        public final Integer getRepeatFrameMsec() {
            return this.repeatFrameMsec;
        }

        public final void setRepeatFrameMsec(Integer repeatFrameMsec) {
            this.repeatFrameMsec = repeatFrameMsec;
        }

        @Override
        public final Builder repeatFrameMsec(Integer repeatFrameMsec) {
            this.repeatFrameMsec = repeatFrameMsec;
            return this;
        }

        public InputLossBehavior build() {
            return new InputLossBehavior(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputLossBehavior> {
        public Builder blackFrameMsec(Integer var1);

        public Builder inputLossImageColor(String var1);

        public Builder inputLossImageSlate(InputLocation var1);

        default public Builder inputLossImageSlate(Consumer<InputLocation.Builder> inputLossImageSlate) {
            return this.inputLossImageSlate((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(inputLossImageSlate)).build());
        }

        public Builder inputLossImageType(String var1);

        public Builder inputLossImageType(InputLossImageType var1);

        public Builder repeatFrameMsec(Integer var1);
    }
}

