/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupSummary;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfDescribeChannelPlacementGroupSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelPlacementGroupsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListChannelPlacementGroupsResponse> {
    private static final SdkField<List<DescribeChannelPlacementGroupSummary>> CHANNEL_PLACEMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelPlacementGroups").getter(ListChannelPlacementGroupsResponse.getter(ListChannelPlacementGroupsResponse::channelPlacementGroups)).setter(ListChannelPlacementGroupsResponse.setter(Builder::channelPlacementGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelPlacementGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeChannelPlacementGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelPlacementGroupsResponse.getter(ListChannelPlacementGroupsResponse::nextToken)).setter(ListChannelPlacementGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_PLACEMENT_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChannelPlacementGroupsResponse.memberNameToFieldInitializer();
    private final List<DescribeChannelPlacementGroupSummary> channelPlacementGroups;
    private final String nextToken;

    private ListChannelPlacementGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.channelPlacementGroups = builder.channelPlacementGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChannelPlacementGroups() {
        return this.channelPlacementGroups != null && !(this.channelPlacementGroups instanceof SdkAutoConstructList);
    }

    public final List<DescribeChannelPlacementGroupSummary> channelPlacementGroups() {
        return this.channelPlacementGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelPlacementGroups() ? this.channelPlacementGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelPlacementGroupsResponse)) {
            return false;
        }
        ListChannelPlacementGroupsResponse other = (ListChannelPlacementGroupsResponse)((Object)obj);
        return this.hasChannelPlacementGroups() == other.hasChannelPlacementGroups() && Objects.equals(this.channelPlacementGroups(), other.channelPlacementGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelPlacementGroupsResponse").add("ChannelPlacementGroups", this.hasChannelPlacementGroups() ? this.channelPlacementGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelPlacementGroups": {
                return Optional.ofNullable(clazz.cast(this.channelPlacementGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelPlacementGroups", CHANNEL_PLACEMENT_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelPlacementGroupsResponse, T> g) {
        return obj -> g.apply((ListChannelPlacementGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<DescribeChannelPlacementGroupSummary> channelPlacementGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelPlacementGroupsResponse model) {
            super(model);
            this.channelPlacementGroups(model.channelPlacementGroups);
            this.nextToken(model.nextToken);
        }

        public final List<DescribeChannelPlacementGroupSummary.Builder> getChannelPlacementGroups() {
            List<DescribeChannelPlacementGroupSummary.Builder> result = ___listOfDescribeChannelPlacementGroupSummaryCopier.copyToBuilder(this.channelPlacementGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelPlacementGroups(Collection<DescribeChannelPlacementGroupSummary.BuilderImpl> channelPlacementGroups) {
            this.channelPlacementGroups = ___listOfDescribeChannelPlacementGroupSummaryCopier.copyFromBuilder(channelPlacementGroups);
        }

        @Override
        public final Builder channelPlacementGroups(Collection<DescribeChannelPlacementGroupSummary> channelPlacementGroups) {
            this.channelPlacementGroups = ___listOfDescribeChannelPlacementGroupSummaryCopier.copy(channelPlacementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelPlacementGroups(DescribeChannelPlacementGroupSummary ... channelPlacementGroups) {
            this.channelPlacementGroups(Arrays.asList(channelPlacementGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelPlacementGroups(Consumer<DescribeChannelPlacementGroupSummary.Builder> ... channelPlacementGroups) {
            this.channelPlacementGroups(Stream.of(channelPlacementGroups).map(c -> (DescribeChannelPlacementGroupSummary)((DescribeChannelPlacementGroupSummary.Builder)DescribeChannelPlacementGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelPlacementGroupsResponse build() {
            return new ListChannelPlacementGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelPlacementGroupsResponse> {
        public Builder channelPlacementGroups(Collection<DescribeChannelPlacementGroupSummary> var1);

        public Builder channelPlacementGroups(DescribeChannelPlacementGroupSummary ... var1);

        public Builder channelPlacementGroups(Consumer<DescribeChannelPlacementGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

