/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.DescribeNodeSummary;
import software.amazon.awssdk.services.medialive.model.ListNodesRequest;
import software.amazon.awssdk.services.medialive.model.ListNodesResponse;

public class ListNodesPublisher
implements SdkPublisher<ListNodesResponse> {
    private final MediaLiveAsyncClient client;
    private final ListNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNodesPublisher(MediaLiveAsyncClient client, ListNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNodesPublisher(MediaLiveAsyncClient client, ListNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeNodeSummary> nodes() {
        Function<ListNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNodesResponseFetcher
    implements AsyncPageFetcher<ListNodesResponse> {
        private ListNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNodesResponse> nextPage(ListNodesResponse previousPage) {
            if (previousPage == null) {
                return ListNodesPublisher.this.client.listNodes(ListNodesPublisher.this.firstRequest);
            }
            return ListNodesPublisher.this.client.listNodes((ListNodesRequest)((Object)ListNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

