/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.BandwidthReductionFilterSettings;
import software.amazon.awssdk.services.medialive.model.TemporalFilterSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H264FilterSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H264FilterSettings> {
    private static final SdkField<TemporalFilterSettings> TEMPORAL_FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemporalFilterSettings").getter(H264FilterSettings.getter(H264FilterSettings::temporalFilterSettings)).setter(H264FilterSettings.setter(Builder::temporalFilterSettings)).constructor(TemporalFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalFilterSettings").build()}).build();
    private static final SdkField<BandwidthReductionFilterSettings> BANDWIDTH_REDUCTION_FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BandwidthReductionFilterSettings").getter(H264FilterSettings.getter(H264FilterSettings::bandwidthReductionFilterSettings)).setter(H264FilterSettings.setter(Builder::bandwidthReductionFilterSettings)).constructor(BandwidthReductionFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthReductionFilterSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPORAL_FILTER_SETTINGS_FIELD, BANDWIDTH_REDUCTION_FILTER_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = H264FilterSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TemporalFilterSettings temporalFilterSettings;
    private final BandwidthReductionFilterSettings bandwidthReductionFilterSettings;

    private H264FilterSettings(BuilderImpl builder) {
        this.temporalFilterSettings = builder.temporalFilterSettings;
        this.bandwidthReductionFilterSettings = builder.bandwidthReductionFilterSettings;
    }

    public final TemporalFilterSettings temporalFilterSettings() {
        return this.temporalFilterSettings;
    }

    public final BandwidthReductionFilterSettings bandwidthReductionFilterSettings() {
        return this.bandwidthReductionFilterSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalFilterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthReductionFilterSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264FilterSettings)) {
            return false;
        }
        H264FilterSettings other = (H264FilterSettings)obj;
        return Objects.equals(this.temporalFilterSettings(), other.temporalFilterSettings()) && Objects.equals(this.bandwidthReductionFilterSettings(), other.bandwidthReductionFilterSettings());
    }

    public final String toString() {
        return ToString.builder((String)"H264FilterSettings").add("TemporalFilterSettings", (Object)this.temporalFilterSettings()).add("BandwidthReductionFilterSettings", (Object)this.bandwidthReductionFilterSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemporalFilterSettings": {
                return Optional.ofNullable(clazz.cast(this.temporalFilterSettings()));
            }
            case "BandwidthReductionFilterSettings": {
                return Optional.ofNullable(clazz.cast(this.bandwidthReductionFilterSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("temporalFilterSettings", TEMPORAL_FILTER_SETTINGS_FIELD);
        map.put("bandwidthReductionFilterSettings", BANDWIDTH_REDUCTION_FILTER_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<H264FilterSettings, T> g) {
        return obj -> g.apply((H264FilterSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TemporalFilterSettings temporalFilterSettings;
        private BandwidthReductionFilterSettings bandwidthReductionFilterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(H264FilterSettings model) {
            this.temporalFilterSettings(model.temporalFilterSettings);
            this.bandwidthReductionFilterSettings(model.bandwidthReductionFilterSettings);
        }

        public final TemporalFilterSettings.Builder getTemporalFilterSettings() {
            return this.temporalFilterSettings != null ? this.temporalFilterSettings.toBuilder() : null;
        }

        public final void setTemporalFilterSettings(TemporalFilterSettings.BuilderImpl temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings != null ? temporalFilterSettings.build() : null;
        }

        @Override
        public final Builder temporalFilterSettings(TemporalFilterSettings temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings;
            return this;
        }

        public final BandwidthReductionFilterSettings.Builder getBandwidthReductionFilterSettings() {
            return this.bandwidthReductionFilterSettings != null ? this.bandwidthReductionFilterSettings.toBuilder() : null;
        }

        public final void setBandwidthReductionFilterSettings(BandwidthReductionFilterSettings.BuilderImpl bandwidthReductionFilterSettings) {
            this.bandwidthReductionFilterSettings = bandwidthReductionFilterSettings != null ? bandwidthReductionFilterSettings.build() : null;
        }

        @Override
        public final Builder bandwidthReductionFilterSettings(BandwidthReductionFilterSettings bandwidthReductionFilterSettings) {
            this.bandwidthReductionFilterSettings = bandwidthReductionFilterSettings;
            return this;
        }

        public H264FilterSettings build() {
            return new H264FilterSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H264FilterSettings> {
        public Builder temporalFilterSettings(TemporalFilterSettings var1);

        default public Builder temporalFilterSettings(Consumer<TemporalFilterSettings.Builder> temporalFilterSettings) {
            return this.temporalFilterSettings((TemporalFilterSettings)((TemporalFilterSettings.Builder)TemporalFilterSettings.builder().applyMutation(temporalFilterSettings)).build());
        }

        public Builder bandwidthReductionFilterSettings(BandwidthReductionFilterSettings var1);

        default public Builder bandwidthReductionFilterSettings(Consumer<BandwidthReductionFilterSettings.Builder> bandwidthReductionFilterSettings) {
            return this.bandwidthReductionFilterSettings((BandwidthReductionFilterSettings)((BandwidthReductionFilterSettings.Builder)BandwidthReductionFilterSettings.builder().applyMutation(bandwidthReductionFilterSettings)).build());
        }
    }
}

