/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CmafId3Behavior {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafId3Behavior> VALUE_MAP;
    private final String value;

    private CmafId3Behavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CmafId3Behavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CmafId3Behavior> knownValues() {
        EnumSet<CmafId3Behavior> knownValues = EnumSet.allOf(CmafId3Behavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CmafId3Behavior.class, CmafId3Behavior::toString);
    }
}

