/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputLocation> {
    private static final SdkField<String> PASSWORD_PARAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputLocation.getter(InputLocation::passwordParam)).setter(InputLocation.setter(Builder::passwordParam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordParam").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputLocation.getter(InputLocation::uri)).setter(InputLocation.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputLocation.getter(InputLocation::username)).setter(InputLocation.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_PARAM_FIELD, URI_FIELD, USERNAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String passwordParam;
    private final String uri;
    private final String username;

    private InputLocation(BuilderImpl builder) {
        this.passwordParam = builder.passwordParam;
        this.uri = builder.uri;
        this.username = builder.username;
    }

    public String passwordParam() {
        return this.passwordParam;
    }

    public String uri() {
        return this.uri;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLocation)) {
            return false;
        }
        InputLocation other = (InputLocation)obj;
        return Objects.equals(this.passwordParam(), other.passwordParam()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"InputLocation").add("PasswordParam", (Object)this.passwordParam()).add("Uri", (Object)this.uri()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PasswordParam": {
                return Optional.ofNullable(clazz.cast(this.passwordParam()));
            }
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputLocation, T> g) {
        return obj -> g.apply((InputLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String passwordParam;
        private String uri;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLocation model) {
            this.passwordParam(model.passwordParam);
            this.uri(model.uri);
            this.username(model.username);
        }

        public final String getPasswordParam() {
            return this.passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public InputLocation build() {
            return new InputLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputLocation> {
        public Builder passwordParam(String var1);

        public Builder uri(String var1);

        public Builder username(String var1);
    }
}

