/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AudioDescription;
import software.amazon.awssdk.services.medialive.model.AvailBlanking;
import software.amazon.awssdk.services.medialive.model.AvailConfiguration;
import software.amazon.awssdk.services.medialive.model.BlackoutSlate;
import software.amazon.awssdk.services.medialive.model.CaptionDescription;
import software.amazon.awssdk.services.medialive.model.GlobalConfiguration;
import software.amazon.awssdk.services.medialive.model.OutputGroup;
import software.amazon.awssdk.services.medialive.model.TimecodeConfig;
import software.amazon.awssdk.services.medialive.model.VideoDescription;
import software.amazon.awssdk.services.medialive.model.___listOfAudioDescriptionCopier;
import software.amazon.awssdk.services.medialive.model.___listOfCaptionDescriptionCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputGroupCopier;
import software.amazon.awssdk.services.medialive.model.___listOfVideoDescriptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncoderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncoderSettings> {
    private static final SdkField<List<AudioDescription>> AUDIO_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncoderSettings.getter(EncoderSettings::audioDescriptions)).setter(EncoderSettings.setter(Builder::audioDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AvailBlanking> AVAIL_BLANKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncoderSettings.getter(EncoderSettings::availBlanking)).setter(EncoderSettings.setter(Builder::availBlanking)).constructor(AvailBlanking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlanking").build()}).build();
    private static final SdkField<AvailConfiguration> AVAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncoderSettings.getter(EncoderSettings::availConfiguration)).setter(EncoderSettings.setter(Builder::availConfiguration)).constructor(AvailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availConfiguration").build()}).build();
    private static final SdkField<BlackoutSlate> BLACKOUT_SLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncoderSettings.getter(EncoderSettings::blackoutSlate)).setter(EncoderSettings.setter(Builder::blackoutSlate)).constructor(BlackoutSlate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackoutSlate").build()}).build();
    private static final SdkField<List<CaptionDescription>> CAPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncoderSettings.getter(EncoderSettings::captionDescriptions)).setter(EncoderSettings.setter(Builder::captionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GlobalConfiguration> GLOBAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncoderSettings.getter(EncoderSettings::globalConfiguration)).setter(EncoderSettings.setter(Builder::globalConfiguration)).constructor(GlobalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalConfiguration").build()}).build();
    private static final SdkField<List<OutputGroup>> OUTPUT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncoderSettings.getter(EncoderSettings::outputGroups)).setter(EncoderSettings.setter(Builder::outputGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimecodeConfig> TIMECODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncoderSettings.getter(EncoderSettings::timecodeConfig)).setter(EncoderSettings.setter(Builder::timecodeConfig)).constructor(TimecodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeConfig").build()}).build();
    private static final SdkField<List<VideoDescription>> VIDEO_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncoderSettings.getter(EncoderSettings::videoDescriptions)).setter(EncoderSettings.setter(Builder::videoDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTIONS_FIELD, AVAIL_BLANKING_FIELD, AVAIL_CONFIGURATION_FIELD, BLACKOUT_SLATE_FIELD, CAPTION_DESCRIPTIONS_FIELD, GLOBAL_CONFIGURATION_FIELD, OUTPUT_GROUPS_FIELD, TIMECODE_CONFIG_FIELD, VIDEO_DESCRIPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AudioDescription> audioDescriptions;
    private final AvailBlanking availBlanking;
    private final AvailConfiguration availConfiguration;
    private final BlackoutSlate blackoutSlate;
    private final List<CaptionDescription> captionDescriptions;
    private final GlobalConfiguration globalConfiguration;
    private final List<OutputGroup> outputGroups;
    private final TimecodeConfig timecodeConfig;
    private final List<VideoDescription> videoDescriptions;

    private EncoderSettings(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.availBlanking = builder.availBlanking;
        this.availConfiguration = builder.availConfiguration;
        this.blackoutSlate = builder.blackoutSlate;
        this.captionDescriptions = builder.captionDescriptions;
        this.globalConfiguration = builder.globalConfiguration;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.videoDescriptions = builder.videoDescriptions;
    }

    public List<AudioDescription> audioDescriptions() {
        return this.audioDescriptions;
    }

    public AvailBlanking availBlanking() {
        return this.availBlanking;
    }

    public AvailConfiguration availConfiguration() {
        return this.availConfiguration;
    }

    public BlackoutSlate blackoutSlate() {
        return this.blackoutSlate;
    }

    public List<CaptionDescription> captionDescriptions() {
        return this.captionDescriptions;
    }

    public GlobalConfiguration globalConfiguration() {
        return this.globalConfiguration;
    }

    public List<OutputGroup> outputGroups() {
        return this.outputGroups;
    }

    public TimecodeConfig timecodeConfig() {
        return this.timecodeConfig;
    }

    public List<VideoDescription> videoDescriptions() {
        return this.videoDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(this.availConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.blackoutSlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncoderSettings)) {
            return false;
        }
        EncoderSettings other = (EncoderSettings)obj;
        return Objects.equals(this.audioDescriptions(), other.audioDescriptions()) && Objects.equals(this.availBlanking(), other.availBlanking()) && Objects.equals(this.availConfiguration(), other.availConfiguration()) && Objects.equals(this.blackoutSlate(), other.blackoutSlate()) && Objects.equals(this.captionDescriptions(), other.captionDescriptions()) && Objects.equals(this.globalConfiguration(), other.globalConfiguration()) && Objects.equals(this.outputGroups(), other.outputGroups()) && Objects.equals(this.timecodeConfig(), other.timecodeConfig()) && Objects.equals(this.videoDescriptions(), other.videoDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"EncoderSettings").add("AudioDescriptions", this.audioDescriptions()).add("AvailBlanking", (Object)this.availBlanking()).add("AvailConfiguration", (Object)this.availConfiguration()).add("BlackoutSlate", (Object)this.blackoutSlate()).add("CaptionDescriptions", this.captionDescriptions()).add("GlobalConfiguration", (Object)this.globalConfiguration()).add("OutputGroups", this.outputGroups()).add("TimecodeConfig", (Object)this.timecodeConfig()).add("VideoDescriptions", this.videoDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptions": {
                return Optional.ofNullable(clazz.cast(this.audioDescriptions()));
            }
            case "AvailBlanking": {
                return Optional.ofNullable(clazz.cast(this.availBlanking()));
            }
            case "AvailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.availConfiguration()));
            }
            case "BlackoutSlate": {
                return Optional.ofNullable(clazz.cast(this.blackoutSlate()));
            }
            case "CaptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.captionDescriptions()));
            }
            case "GlobalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.globalConfiguration()));
            }
            case "OutputGroups": {
                return Optional.ofNullable(clazz.cast(this.outputGroups()));
            }
            case "TimecodeConfig": {
                return Optional.ofNullable(clazz.cast(this.timecodeConfig()));
            }
            case "VideoDescriptions": {
                return Optional.ofNullable(clazz.cast(this.videoDescriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncoderSettings, T> g) {
        return obj -> g.apply((EncoderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioDescription> audioDescriptions = DefaultSdkAutoConstructList.getInstance();
        private AvailBlanking availBlanking;
        private AvailConfiguration availConfiguration;
        private BlackoutSlate blackoutSlate;
        private List<CaptionDescription> captionDescriptions = DefaultSdkAutoConstructList.getInstance();
        private GlobalConfiguration globalConfiguration;
        private List<OutputGroup> outputGroups = DefaultSdkAutoConstructList.getInstance();
        private TimecodeConfig timecodeConfig;
        private List<VideoDescription> videoDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EncoderSettings model) {
            this.audioDescriptions(model.audioDescriptions);
            this.availBlanking(model.availBlanking);
            this.availConfiguration(model.availConfiguration);
            this.blackoutSlate(model.blackoutSlate);
            this.captionDescriptions(model.captionDescriptions);
            this.globalConfiguration(model.globalConfiguration);
            this.outputGroups(model.outputGroups);
            this.timecodeConfig(model.timecodeConfig);
            this.videoDescriptions(model.videoDescriptions);
        }

        public final Collection<AudioDescription.Builder> getAudioDescriptions() {
            return this.audioDescriptions != null ? (Collection)this.audioDescriptions.stream().map(AudioDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription ... audioDescriptions) {
            this.audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder> ... audioDescriptions) {
            this.audioDescriptions(Stream.of(audioDescriptions).map(c -> (AudioDescription)((AudioDescription.Builder)AudioDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return this.availBlanking != null ? this.availBlanking.toBuilder() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        public final AvailConfiguration.Builder getAvailConfiguration() {
            return this.availConfiguration != null ? this.availConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder availConfiguration(AvailConfiguration availConfiguration) {
            this.availConfiguration = availConfiguration;
            return this;
        }

        public final void setAvailConfiguration(AvailConfiguration.BuilderImpl availConfiguration) {
            this.availConfiguration = availConfiguration != null ? availConfiguration.build() : null;
        }

        public final BlackoutSlate.Builder getBlackoutSlate() {
            return this.blackoutSlate != null ? this.blackoutSlate.toBuilder() : null;
        }

        @Override
        public final Builder blackoutSlate(BlackoutSlate blackoutSlate) {
            this.blackoutSlate = blackoutSlate;
            return this;
        }

        public final void setBlackoutSlate(BlackoutSlate.BuilderImpl blackoutSlate) {
            this.blackoutSlate = blackoutSlate != null ? blackoutSlate.build() : null;
        }

        public final Collection<CaptionDescription.Builder> getCaptionDescriptions() {
            return this.captionDescriptions != null ? (Collection)this.captionDescriptions.stream().map(CaptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescription ... captionDescriptions) {
            this.captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescription.Builder> ... captionDescriptions) {
            this.captionDescriptions(Stream.of(captionDescriptions).map(c -> (CaptionDescription)((CaptionDescription.Builder)CaptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescription.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copyFromBuilder(captionDescriptions);
        }

        public final GlobalConfiguration.Builder getGlobalConfiguration() {
            return this.globalConfiguration != null ? this.globalConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder globalConfiguration(GlobalConfiguration globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
            return this;
        }

        public final void setGlobalConfiguration(GlobalConfiguration.BuilderImpl globalConfiguration) {
            this.globalConfiguration = globalConfiguration != null ? globalConfiguration.build() : null;
        }

        public final Collection<OutputGroup.Builder> getOutputGroups() {
            return this.outputGroups != null ? (Collection)this.outputGroups.stream().map(OutputGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup ... outputGroups) {
            this.outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder> ... outputGroups) {
            this.outputGroups(Stream.of(outputGroups).map(c -> (OutputGroup)((OutputGroup.Builder)OutputGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return this.timecodeConfig != null ? this.timecodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        public final Collection<VideoDescription.Builder> getVideoDescriptions() {
            return this.videoDescriptions != null ? (Collection)this.videoDescriptions.stream().map(VideoDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder videoDescriptions(Collection<VideoDescription> videoDescriptions) {
            this.videoDescriptions = ___listOfVideoDescriptionCopier.copy(videoDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoDescriptions(VideoDescription ... videoDescriptions) {
            this.videoDescriptions(Arrays.asList(videoDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoDescriptions(Consumer<VideoDescription.Builder> ... videoDescriptions) {
            this.videoDescriptions(Stream.of(videoDescriptions).map(c -> (VideoDescription)((VideoDescription.Builder)VideoDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVideoDescriptions(Collection<VideoDescription.BuilderImpl> videoDescriptions) {
            this.videoDescriptions = ___listOfVideoDescriptionCopier.copyFromBuilder(videoDescriptions);
        }

        public EncoderSettings build() {
            return new EncoderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncoderSettings> {
        public Builder audioDescriptions(Collection<AudioDescription> var1);

        public Builder audioDescriptions(AudioDescription ... var1);

        public Builder audioDescriptions(Consumer<AudioDescription.Builder> ... var1);

        public Builder availBlanking(AvailBlanking var1);

        default public Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return this.availBlanking((AvailBlanking)((AvailBlanking.Builder)AvailBlanking.builder().applyMutation(availBlanking)).build());
        }

        public Builder availConfiguration(AvailConfiguration var1);

        default public Builder availConfiguration(Consumer<AvailConfiguration.Builder> availConfiguration) {
            return this.availConfiguration((AvailConfiguration)((AvailConfiguration.Builder)AvailConfiguration.builder().applyMutation(availConfiguration)).build());
        }

        public Builder blackoutSlate(BlackoutSlate var1);

        default public Builder blackoutSlate(Consumer<BlackoutSlate.Builder> blackoutSlate) {
            return this.blackoutSlate((BlackoutSlate)((BlackoutSlate.Builder)BlackoutSlate.builder().applyMutation(blackoutSlate)).build());
        }

        public Builder captionDescriptions(Collection<CaptionDescription> var1);

        public Builder captionDescriptions(CaptionDescription ... var1);

        public Builder captionDescriptions(Consumer<CaptionDescription.Builder> ... var1);

        public Builder globalConfiguration(GlobalConfiguration var1);

        default public Builder globalConfiguration(Consumer<GlobalConfiguration.Builder> globalConfiguration) {
            return this.globalConfiguration((GlobalConfiguration)((GlobalConfiguration.Builder)GlobalConfiguration.builder().applyMutation(globalConfiguration)).build());
        }

        public Builder outputGroups(Collection<OutputGroup> var1);

        public Builder outputGroups(OutputGroup ... var1);

        public Builder outputGroups(Consumer<OutputGroup.Builder> ... var1);

        public Builder timecodeConfig(TimecodeConfig var1);

        default public Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return this.timecodeConfig((TimecodeConfig)((TimecodeConfig.Builder)TimecodeConfig.builder().applyMutation(timecodeConfig)).build());
        }

        public Builder videoDescriptions(Collection<VideoDescription> var1);

        public Builder videoDescriptions(VideoDescription ... var1);

        public Builder videoDescriptions(Consumer<VideoDescription.Builder> ... var1);
    }
}

