/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ThumbnailType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Thumbnail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Thumbnail> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(Thumbnail.getter(Thumbnail::body)).setter(Thumbnail.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(Thumbnail.getter(Thumbnail::contentType)).setter(Thumbnail.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> THUMBNAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThumbnailType").getter(Thumbnail.getter(Thumbnail::thumbnailTypeAsString)).setter(Thumbnail.setter(Builder::thumbnailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailType").build()}).build();
    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TimeStamp").getter(Thumbnail.getter(Thumbnail::timeStamp)).setter(Thumbnail.setter(Builder::timeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeStamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, CONTENT_TYPE_FIELD, THUMBNAIL_TYPE_FIELD, TIME_STAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Thumbnail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String contentType;
    private final String thumbnailType;
    private final Instant timeStamp;

    private Thumbnail(BuilderImpl builder) {
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.thumbnailType = builder.thumbnailType;
        this.timeStamp = builder.timeStamp;
    }

    public final String body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final ThumbnailType thumbnailType() {
        return ThumbnailType.fromValue(this.thumbnailType);
    }

    public final String thumbnailTypeAsString() {
        return this.thumbnailType;
    }

    public final Instant timeStamp() {
        return this.timeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Thumbnail)) {
            return false;
        }
        Thumbnail other = (Thumbnail)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.thumbnailTypeAsString(), other.thumbnailTypeAsString()) && Objects.equals(this.timeStamp(), other.timeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"Thumbnail").add("Body", (Object)this.body()).add("ContentType", (Object)this.contentType()).add("ThumbnailType", (Object)this.thumbnailTypeAsString()).add("TimeStamp", (Object)this.timeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "ThumbnailType": {
                return Optional.ofNullable(clazz.cast(this.thumbnailTypeAsString()));
            }
            case "TimeStamp": {
                return Optional.ofNullable(clazz.cast(this.timeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("body", BODY_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("thumbnailType", THUMBNAIL_TYPE_FIELD);
        map.put("timeStamp", TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Thumbnail, T> g) {
        return obj -> g.apply((Thumbnail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String contentType;
        private String thumbnailType;
        private Instant timeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Thumbnail model) {
            this.body(model.body);
            this.contentType(model.contentType);
            this.thumbnailType(model.thumbnailType);
            this.timeStamp(model.timeStamp);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getThumbnailType() {
            return this.thumbnailType;
        }

        public final void setThumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
        }

        @Override
        public final Builder thumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
            return this;
        }

        @Override
        public final Builder thumbnailType(ThumbnailType thumbnailType) {
            this.thumbnailType(thumbnailType == null ? null : thumbnailType.toString());
            return this;
        }

        public final Instant getTimeStamp() {
            return this.timeStamp;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public Thumbnail build() {
            return new Thumbnail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Thumbnail> {
        public Builder body(String var1);

        public Builder contentType(String var1);

        public Builder thumbnailType(String var1);

        public Builder thumbnailType(ThumbnailType var1);

        public Builder timeStamp(Instant var1);
    }
}

