/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMultiplexProgramRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateMultiplexProgramRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiplexId").getter(UpdateMultiplexProgramRequest.getter(UpdateMultiplexProgramRequest::multiplexId)).setter(UpdateMultiplexProgramRequest.setter(Builder::multiplexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()}).build();
    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexProgramSettings").getter(UpdateMultiplexProgramRequest.getter(UpdateMultiplexProgramRequest::multiplexProgramSettings)).setter(UpdateMultiplexProgramRequest.setter(Builder::multiplexProgramSettings)).constructor(MultiplexProgramSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(UpdateMultiplexProgramRequest.getter(UpdateMultiplexProgramRequest::programName)).setter(UpdateMultiplexProgramRequest.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("programName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD, MULTIPLEX_PROGRAM_SETTINGS_FIELD, PROGRAM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMultiplexProgramRequest.memberNameToFieldInitializer();
    private final String multiplexId;
    private final MultiplexProgramSettings multiplexProgramSettings;
    private final String programName;

    private UpdateMultiplexProgramRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.programName = builder.programName;
    }

    public final String multiplexId() {
        return this.multiplexId;
    }

    public final MultiplexProgramSettings multiplexProgramSettings() {
        return this.multiplexProgramSettings;
    }

    public final String programName() {
        return this.programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexProgramRequest)) {
            return false;
        }
        UpdateMultiplexProgramRequest other = (UpdateMultiplexProgramRequest)((Object)obj);
        return Objects.equals(this.multiplexId(), other.multiplexId()) && Objects.equals(this.multiplexProgramSettings(), other.multiplexProgramSettings()) && Objects.equals(this.programName(), other.programName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMultiplexProgramRequest").add("MultiplexId", (Object)this.multiplexId()).add("MultiplexProgramSettings", (Object)this.multiplexProgramSettings()).add("ProgramName", (Object)this.programName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiplexId": {
                return Optional.ofNullable(clazz.cast(this.multiplexId()));
            }
            case "MultiplexProgramSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexProgramSettings()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("multiplexId", MULTIPLEX_ID_FIELD);
        map.put("multiplexProgramSettings", MULTIPLEX_PROGRAM_SETTINGS_FIELD);
        map.put("programName", PROGRAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexProgramRequest, T> g) {
        return obj -> g.apply((UpdateMultiplexProgramRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String multiplexId;
        private MultiplexProgramSettings multiplexProgramSettings;
        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexProgramRequest model) {
            super(model);
            this.multiplexId(model.multiplexId);
            this.multiplexProgramSettings(model.multiplexProgramSettings);
            this.programName(model.programName);
        }

        public final String getMultiplexId() {
            return this.multiplexId;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return this.multiplexProgramSettings != null ? this.multiplexProgramSettings.toBuilder() : null;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiplexProgramRequest build() {
            return new UpdateMultiplexProgramRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMultiplexProgramRequest> {
        public Builder multiplexId(String var1);

        public Builder multiplexProgramSettings(MultiplexProgramSettings var1);

        default public Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return this.multiplexProgramSettings((MultiplexProgramSettings)((MultiplexProgramSettings.Builder)MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings)).build());
        }

        public Builder programName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

