/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, BatchDeleteRequest> {
    private static final SdkField<List<String>> CHANNEL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelIds").getter(BatchDeleteRequest.getter(BatchDeleteRequest::channelIds)).setter(BatchDeleteRequest.setter(Builder::channelIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputIds").getter(BatchDeleteRequest.getter(BatchDeleteRequest::inputIds)).setter(BatchDeleteRequest.setter(Builder::inputIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputSecurityGroupIds").getter(BatchDeleteRequest.getter(BatchDeleteRequest::inputSecurityGroupIds)).setter(BatchDeleteRequest.setter(Builder::inputSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MULTIPLEX_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiplexIds").getter(BatchDeleteRequest.getter(BatchDeleteRequest::multiplexIds)).setter(BatchDeleteRequest.setter(Builder::multiplexIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_IDS_FIELD, INPUT_IDS_FIELD, INPUT_SECURITY_GROUP_IDS_FIELD, MULTIPLEX_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteRequest.memberNameToFieldInitializer();
    private final List<String> channelIds;
    private final List<String> inputIds;
    private final List<String> inputSecurityGroupIds;
    private final List<String> multiplexIds;

    private BatchDeleteRequest(BuilderImpl builder) {
        super(builder);
        this.channelIds = builder.channelIds;
        this.inputIds = builder.inputIds;
        this.inputSecurityGroupIds = builder.inputSecurityGroupIds;
        this.multiplexIds = builder.multiplexIds;
    }

    public final boolean hasChannelIds() {
        return this.channelIds != null && !(this.channelIds instanceof SdkAutoConstructList);
    }

    public final List<String> channelIds() {
        return this.channelIds;
    }

    public final boolean hasInputIds() {
        return this.inputIds != null && !(this.inputIds instanceof SdkAutoConstructList);
    }

    public final List<String> inputIds() {
        return this.inputIds;
    }

    public final boolean hasInputSecurityGroupIds() {
        return this.inputSecurityGroupIds != null && !(this.inputSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> inputSecurityGroupIds() {
        return this.inputSecurityGroupIds;
    }

    public final boolean hasMultiplexIds() {
        return this.multiplexIds != null && !(this.multiplexIds instanceof SdkAutoConstructList);
    }

    public final List<String> multiplexIds() {
        return this.multiplexIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelIds() ? this.channelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputIds() ? this.inputIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSecurityGroupIds() ? this.inputSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiplexIds() ? this.multiplexIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRequest)) {
            return false;
        }
        BatchDeleteRequest other = (BatchDeleteRequest)((Object)obj);
        return this.hasChannelIds() == other.hasChannelIds() && Objects.equals(this.channelIds(), other.channelIds()) && this.hasInputIds() == other.hasInputIds() && Objects.equals(this.inputIds(), other.inputIds()) && this.hasInputSecurityGroupIds() == other.hasInputSecurityGroupIds() && Objects.equals(this.inputSecurityGroupIds(), other.inputSecurityGroupIds()) && this.hasMultiplexIds() == other.hasMultiplexIds() && Objects.equals(this.multiplexIds(), other.multiplexIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteRequest").add("ChannelIds", this.hasChannelIds() ? this.channelIds() : null).add("InputIds", this.hasInputIds() ? this.inputIds() : null).add("InputSecurityGroupIds", this.hasInputSecurityGroupIds() ? this.inputSecurityGroupIds() : null).add("MultiplexIds", this.hasMultiplexIds() ? this.multiplexIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelIds": {
                return Optional.ofNullable(clazz.cast(this.channelIds()));
            }
            case "InputIds": {
                return Optional.ofNullable(clazz.cast(this.inputIds()));
            }
            case "InputSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroupIds()));
            }
            case "MultiplexIds": {
                return Optional.ofNullable(clazz.cast(this.multiplexIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("channelIds", CHANNEL_IDS_FIELD);
        map.put("inputIds", INPUT_IDS_FIELD);
        map.put("inputSecurityGroupIds", INPUT_SECURITY_GROUP_IDS_FIELD);
        map.put("multiplexIds", MULTIPLEX_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRequest, T> g) {
        return obj -> g.apply((BatchDeleteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<String> channelIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> inputIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> inputSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> multiplexIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRequest model) {
            super(model);
            this.channelIds(model.channelIds);
            this.inputIds(model.inputIds);
            this.inputSecurityGroupIds(model.inputSecurityGroupIds);
            this.multiplexIds(model.multiplexIds);
        }

        public final Collection<String> getChannelIds() {
            if (this.channelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channelIds;
        }

        public final void setChannelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
        }

        @Override
        public final Builder channelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelIds(String ... channelIds) {
            this.channelIds(Arrays.asList(channelIds));
            return this;
        }

        public final Collection<String> getInputIds() {
            if (this.inputIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputIds;
        }

        public final void setInputIds(Collection<String> inputIds) {
            this.inputIds = ___listOf__stringCopier.copy(inputIds);
        }

        @Override
        public final Builder inputIds(Collection<String> inputIds) {
            this.inputIds = ___listOf__stringCopier.copy(inputIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputIds(String ... inputIds) {
            this.inputIds(Arrays.asList(inputIds));
            return this;
        }

        public final Collection<String> getInputSecurityGroupIds() {
            if (this.inputSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputSecurityGroupIds;
        }

        public final void setInputSecurityGroupIds(Collection<String> inputSecurityGroupIds) {
            this.inputSecurityGroupIds = ___listOf__stringCopier.copy(inputSecurityGroupIds);
        }

        @Override
        public final Builder inputSecurityGroupIds(Collection<String> inputSecurityGroupIds) {
            this.inputSecurityGroupIds = ___listOf__stringCopier.copy(inputSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroupIds(String ... inputSecurityGroupIds) {
            this.inputSecurityGroupIds(Arrays.asList(inputSecurityGroupIds));
            return this;
        }

        public final Collection<String> getMultiplexIds() {
            if (this.multiplexIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.multiplexIds;
        }

        public final void setMultiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
        }

        @Override
        public final Builder multiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexIds(String ... multiplexIds) {
            this.multiplexIds(Arrays.asList(multiplexIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteRequest build() {
            return new BatchDeleteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteRequest> {
        public Builder channelIds(Collection<String> var1);

        public Builder channelIds(String ... var1);

        public Builder inputIds(Collection<String> var1);

        public Builder inputIds(String ... var1);

        public Builder inputSecurityGroupIds(Collection<String> var1);

        public Builder inputSecurityGroupIds(String ... var1);

        public Builder multiplexIds(Collection<String> var1);

        public Builder multiplexIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

